/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsByCustomizationResponse;

public class ListDistributionTenantsByCustomizationIterable
implements SdkIterable<ListDistributionTenantsByCustomizationResponse> {
    private final CloudFrontClient client;
    private final ListDistributionTenantsByCustomizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionTenantsByCustomizationIterable(CloudFrontClient client, ListDistributionTenantsByCustomizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionTenantsByCustomizationResponseFetcher();
    }

    public Iterator<ListDistributionTenantsByCustomizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionTenantSummary> distributionTenantList() {
        Function<ListDistributionTenantsByCustomizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionTenantList() != null) {
                return response.distributionTenantList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionTenantsByCustomizationResponseFetcher
    implements SyncPageFetcher<ListDistributionTenantsByCustomizationResponse> {
        private ListDistributionTenantsByCustomizationResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionTenantsByCustomizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListDistributionTenantsByCustomizationResponse nextPage(ListDistributionTenantsByCustomizationResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionTenantsByCustomizationIterable.this.client.listDistributionTenantsByCustomization(ListDistributionTenantsByCustomizationIterable.this.firstRequest);
            }
            return ListDistributionTenantsByCustomizationIterable.this.client.listDistributionTenantsByCustomization((ListDistributionTenantsByCustomizationRequest)((Object)ListDistributionTenantsByCustomizationIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

