/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.cloudfront.model.TrustStoreSummary;

public class ListTrustStoresIterable
implements SdkIterable<ListTrustStoresResponse> {
    private final CloudFrontClient client;
    private final ListTrustStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustStoresIterable(CloudFrontClient client, ListTrustStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrustStoresResponseFetcher();
    }

    public Iterator<ListTrustStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrustStoreSummary> trustStoreList() {
        Function<ListTrustStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustStoreList() != null) {
                return response.trustStoreList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrustStoresResponseFetcher
    implements SyncPageFetcher<ListTrustStoresResponse> {
        private ListTrustStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListTrustStoresResponse nextPage(ListTrustStoresResponse previousPage) {
            if (previousPage == null) {
                return ListTrustStoresIterable.this.client.listTrustStores(ListTrustStoresIterable.this.firstRequest);
            }
            return ListTrustStoresIterable.this.client.listTrustStores((ListTrustStoresRequest)((Object)ListTrustStoresIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

