/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupRetentionPolicy;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.services.cloudhsmv2.model.ClusterMode;
import software.amazon.awssdk.services.cloudhsmv2.model.NetworkType;
import software.amazon.awssdk.services.cloudhsmv2.model.SubnetIdsCopier;
import software.amazon.awssdk.services.cloudhsmv2.model.Tag;
import software.amazon.awssdk.services.cloudhsmv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<BackupRetentionPolicy> BACKUP_RETENTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupRetentionPolicy").getter(CreateClusterRequest.getter(CreateClusterRequest::backupRetentionPolicy)).setter(CreateClusterRequest.setter(Builder::backupRetentionPolicy)).constructor(BackupRetentionPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPolicy").build()}).build();
    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmType").getter(CreateClusterRequest.getter(CreateClusterRequest::hsmType)).setter(CreateClusterRequest.setter(Builder::hsmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupId").getter(CreateClusterRequest.getter(CreateClusterRequest::sourceBackupId)).setter(CreateClusterRequest.setter(Builder::sourceBackupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateClusterRequest.getter(CreateClusterRequest::subnetIds)).setter(CreateClusterRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateClusterRequest.getter(CreateClusterRequest::networkTypeAsString)).setter(CreateClusterRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(CreateClusterRequest.getter(CreateClusterRequest::tagList)).setter(CreateClusterRequest.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(CreateClusterRequest.getter(CreateClusterRequest::modeAsString)).setter(CreateClusterRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RETENTION_POLICY_FIELD, HSM_TYPE_FIELD, SOURCE_BACKUP_ID_FIELD, SUBNET_IDS_FIELD, NETWORK_TYPE_FIELD, TAG_LIST_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClusterRequest.memberNameToFieldInitializer();
    private final BackupRetentionPolicy backupRetentionPolicy;
    private final String hsmType;
    private final String sourceBackupId;
    private final List<String> subnetIds;
    private final String networkType;
    private final List<Tag> tagList;
    private final String mode;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.backupRetentionPolicy = builder.backupRetentionPolicy;
        this.hsmType = builder.hsmType;
        this.sourceBackupId = builder.sourceBackupId;
        this.subnetIds = builder.subnetIds;
        this.networkType = builder.networkType;
        this.tagList = builder.tagList;
        this.mode = builder.mode;
    }

    public final BackupRetentionPolicy backupRetentionPolicy() {
        return this.backupRetentionPolicy;
    }

    public final String hsmType() {
        return this.hsmType;
    }

    public final String sourceBackupId() {
        return this.sourceBackupId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final ClusterMode mode() {
        return ClusterMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.backupRetentionPolicy(), other.backupRetentionPolicy()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.sourceBackupId(), other.sourceBackupId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("BackupRetentionPolicy", (Object)this.backupRetentionPolicy()).add("HsmType", (Object)this.hsmType()).add("SourceBackupId", (Object)this.sourceBackupId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("NetworkType", (Object)this.networkTypeAsString()).add("TagList", this.hasTagList() ? this.tagList() : null).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupRetentionPolicy": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPolicy()));
            }
            case "HsmType": {
                return Optional.ofNullable(clazz.cast(this.hsmType()));
            }
            case "SourceBackupId": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupRetentionPolicy", BACKUP_RETENTION_POLICY_FIELD);
        map.put("HsmType", HSM_TYPE_FIELD);
        map.put("SourceBackupId", SOURCE_BACKUP_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private BackupRetentionPolicy backupRetentionPolicy;
        private String hsmType;
        private String sourceBackupId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String networkType;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.backupRetentionPolicy(model.backupRetentionPolicy);
            this.hsmType(model.hsmType);
            this.sourceBackupId(model.sourceBackupId);
            this.subnetIds(model.subnetIds);
            this.networkType(model.networkType);
            this.tagList(model.tagList);
            this.mode(model.mode);
        }

        public final BackupRetentionPolicy.Builder getBackupRetentionPolicy() {
            return this.backupRetentionPolicy != null ? this.backupRetentionPolicy.toBuilder() : null;
        }

        public final void setBackupRetentionPolicy(BackupRetentionPolicy.BuilderImpl backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy != null ? backupRetentionPolicy.build() : null;
        }

        @Override
        public final Builder backupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy;
            return this;
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final String getSourceBackupId() {
            return this.sourceBackupId;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudHsmV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder backupRetentionPolicy(BackupRetentionPolicy var1);

        default public Builder backupRetentionPolicy(Consumer<BackupRetentionPolicy.Builder> backupRetentionPolicy) {
            return this.backupRetentionPolicy((BackupRetentionPolicy)((BackupRetentionPolicy.Builder)BackupRetentionPolicy.builder().applyMutation(backupRetentionPolicy)).build());
        }

        public Builder hsmType(String var1);

        public Builder sourceBackupId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder mode(String var1);

        public Builder mode(ClusterMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

