/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionOriginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVersionOrigin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVersionOrigin> {
    private static final SdkField<DomainEntryPoint> DOMAIN_ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("domainEntryPoint").getter(PackageVersionOrigin.getter(PackageVersionOrigin::domainEntryPoint)).setter(PackageVersionOrigin.setter(Builder::domainEntryPoint)).constructor(DomainEntryPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEntryPoint").build()}).build();
    private static final SdkField<String> ORIGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originType").getter(PackageVersionOrigin.getter(PackageVersionOrigin::originTypeAsString)).setter(PackageVersionOrigin.setter(Builder::originType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ENTRY_POINT_FIELD, ORIGIN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageVersionOrigin.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DomainEntryPoint domainEntryPoint;
    private final String originType;

    private PackageVersionOrigin(BuilderImpl builder) {
        this.domainEntryPoint = builder.domainEntryPoint;
        this.originType = builder.originType;
    }

    public final DomainEntryPoint domainEntryPoint() {
        return this.domainEntryPoint;
    }

    public final PackageVersionOriginType originType() {
        return PackageVersionOriginType.fromValue(this.originType);
    }

    public final String originTypeAsString() {
        return this.originType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEntryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.originTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionOrigin)) {
            return false;
        }
        PackageVersionOrigin other = (PackageVersionOrigin)obj;
        return Objects.equals(this.domainEntryPoint(), other.domainEntryPoint()) && Objects.equals(this.originTypeAsString(), other.originTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVersionOrigin").add("DomainEntryPoint", (Object)this.domainEntryPoint()).add("OriginType", (Object)this.originTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainEntryPoint": {
                return Optional.ofNullable(clazz.cast(this.domainEntryPoint()));
            }
            case "originType": {
                return Optional.ofNullable(clazz.cast(this.originTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainEntryPoint", DOMAIN_ENTRY_POINT_FIELD);
        map.put("originType", ORIGIN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionOrigin, T> g) {
        return obj -> g.apply((PackageVersionOrigin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DomainEntryPoint domainEntryPoint;
        private String originType;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionOrigin model) {
            this.domainEntryPoint(model.domainEntryPoint);
            this.originType(model.originType);
        }

        public final DomainEntryPoint.Builder getDomainEntryPoint() {
            return this.domainEntryPoint != null ? this.domainEntryPoint.toBuilder() : null;
        }

        public final void setDomainEntryPoint(DomainEntryPoint.BuilderImpl domainEntryPoint) {
            this.domainEntryPoint = domainEntryPoint != null ? domainEntryPoint.build() : null;
        }

        @Override
        public final Builder domainEntryPoint(DomainEntryPoint domainEntryPoint) {
            this.domainEntryPoint = domainEntryPoint;
            return this;
        }

        public final String getOriginType() {
            return this.originType;
        }

        public final void setOriginType(String originType) {
            this.originType = originType;
        }

        @Override
        public final Builder originType(String originType) {
            this.originType = originType;
            return this;
        }

        @Override
        public final Builder originType(PackageVersionOriginType originType) {
            this.originType(originType == null ? null : originType.toString());
            return this;
        }

        public PackageVersionOrigin build() {
            return new PackageVersionOrigin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVersionOrigin> {
        public Builder domainEntryPoint(DomainEntryPoint var1);

        default public Builder domainEntryPoint(Consumer<DomainEntryPoint.Builder> domainEntryPoint) {
            return this.domainEntryPoint((DomainEntryPoint)((DomainEntryPoint.Builder)DomainEntryPoint.builder().applyMutation(domainEntryPoint)).build());
        }

        public Builder originType(String var1);

        public Builder originType(PackageVersionOriginType var1);
    }
}

