/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.CodeStarConnectionsRequest;
import software.amazon.awssdk.services.codestarconnections.model.SyncConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSyncStatusRequest
extends CodeStarConnectionsRequest
implements ToCopyableBuilder<Builder, GetResourceSyncStatusRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(GetResourceSyncStatusRequest.getter(GetResourceSyncStatusRequest::resourceName)).setter(GetResourceSyncStatusRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncType").getter(GetResourceSyncStatusRequest.getter(GetResourceSyncStatusRequest::syncTypeAsString)).setter(GetResourceSyncStatusRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, SYNC_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceSyncStatusRequest.memberNameToFieldInitializer();
    private final String resourceName;
    private final String syncType;

    private GetResourceSyncStatusRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.syncType = builder.syncType;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final SyncConfigurationType syncType() {
        return SyncConfigurationType.fromValue(this.syncType);
    }

    public final String syncTypeAsString() {
        return this.syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSyncStatusRequest)) {
            return false;
        }
        GetResourceSyncStatusRequest other = (GetResourceSyncStatusRequest)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.syncTypeAsString(), other.syncTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSyncStatusRequest").add("ResourceName", (Object)this.resourceName()).add("SyncType", (Object)this.syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "SyncType": {
                return Optional.ofNullable(clazz.cast(this.syncTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("SyncType", SYNC_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSyncStatusRequest, T> g) {
        return obj -> g.apply((GetResourceSyncStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarConnectionsRequest.BuilderImpl
    implements Builder {
        private String resourceName;
        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSyncStatusRequest model) {
            super(model);
            this.resourceName(model.resourceName);
            this.syncType(model.syncType);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncConfigurationType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceSyncStatusRequest build() {
            return new GetResourceSyncStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeStarConnectionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSyncStatusRequest> {
        public Builder resourceName(String var1);

        public Builder syncType(String var1);

        public Builder syncType(SyncConfigurationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

