/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetUserPoolMfaConfigResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, SetUserPoolMfaConfigResponse> {
    private static final SdkField<SmsMfaConfigType> SMS_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmsMfaConfiguration").getter(SetUserPoolMfaConfigResponse.getter(SetUserPoolMfaConfigResponse::smsMfaConfiguration)).setter(SetUserPoolMfaConfigResponse.setter(Builder::smsMfaConfiguration)).constructor(SmsMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMfaConfiguration").build()}).build();
    private static final SdkField<SoftwareTokenMfaConfigType> SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareTokenMfaConfiguration").getter(SetUserPoolMfaConfigResponse.getter(SetUserPoolMfaConfigResponse::softwareTokenMfaConfiguration)).setter(SetUserPoolMfaConfigResponse.setter(Builder::softwareTokenMfaConfiguration)).constructor(SoftwareTokenMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaConfiguration").build()}).build();
    private static final SdkField<EmailMfaConfigType> EMAIL_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMfaConfiguration").getter(SetUserPoolMfaConfigResponse.getter(SetUserPoolMfaConfigResponse::emailMfaConfiguration)).setter(SetUserPoolMfaConfigResponse.setter(Builder::emailMfaConfiguration)).constructor(EmailMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMfaConfiguration").build()}).build();
    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MfaConfiguration").getter(SetUserPoolMfaConfigResponse.getter(SetUserPoolMfaConfigResponse::mfaConfigurationAsString)).setter(SetUserPoolMfaConfigResponse.setter(Builder::mfaConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()}).build();
    private static final SdkField<WebAuthnConfigurationType> WEB_AUTHN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebAuthnConfiguration").getter(SetUserPoolMfaConfigResponse.getter(SetUserPoolMfaConfigResponse::webAuthnConfiguration)).setter(SetUserPoolMfaConfigResponse.setter(Builder::webAuthnConfiguration)).constructor(WebAuthnConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAuthnConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_CONFIGURATION_FIELD, SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD, EMAIL_MFA_CONFIGURATION_FIELD, MFA_CONFIGURATION_FIELD, WEB_AUTHN_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetUserPoolMfaConfigResponse.memberNameToFieldInitializer();
    private final SmsMfaConfigType smsMfaConfiguration;
    private final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
    private final EmailMfaConfigType emailMfaConfiguration;
    private final String mfaConfiguration;
    private final WebAuthnConfigurationType webAuthnConfiguration;

    private SetUserPoolMfaConfigResponse(BuilderImpl builder) {
        super(builder);
        this.smsMfaConfiguration = builder.smsMfaConfiguration;
        this.softwareTokenMfaConfiguration = builder.softwareTokenMfaConfiguration;
        this.emailMfaConfiguration = builder.emailMfaConfiguration;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.webAuthnConfiguration = builder.webAuthnConfiguration;
    }

    public final SmsMfaConfigType smsMfaConfiguration() {
        return this.smsMfaConfiguration;
    }

    public final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration() {
        return this.softwareTokenMfaConfiguration;
    }

    public final EmailMfaConfigType emailMfaConfiguration() {
        return this.emailMfaConfiguration;
    }

    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public final String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    public final WebAuthnConfigurationType webAuthnConfiguration() {
        return this.webAuthnConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareTokenMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAuthnConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserPoolMfaConfigResponse)) {
            return false;
        }
        SetUserPoolMfaConfigResponse other = (SetUserPoolMfaConfigResponse)((Object)obj);
        return Objects.equals(this.smsMfaConfiguration(), other.smsMfaConfiguration()) && Objects.equals(this.softwareTokenMfaConfiguration(), other.softwareTokenMfaConfiguration()) && Objects.equals(this.emailMfaConfiguration(), other.emailMfaConfiguration()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString()) && Objects.equals(this.webAuthnConfiguration(), other.webAuthnConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SetUserPoolMfaConfigResponse").add("SmsMfaConfiguration", (Object)this.smsMfaConfiguration()).add("SoftwareTokenMfaConfiguration", (Object)this.softwareTokenMfaConfiguration()).add("EmailMfaConfiguration", (Object)this.emailMfaConfiguration()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).add("WebAuthnConfiguration", (Object)this.webAuthnConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmsMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsMfaConfiguration()));
            }
            case "SoftwareTokenMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.softwareTokenMfaConfiguration()));
            }
            case "EmailMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.emailMfaConfiguration()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
            case "WebAuthnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.webAuthnConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SmsMfaConfiguration", SMS_MFA_CONFIGURATION_FIELD);
        map.put("SoftwareTokenMfaConfiguration", SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD);
        map.put("EmailMfaConfiguration", EMAIL_MFA_CONFIGURATION_FIELD);
        map.put("MfaConfiguration", MFA_CONFIGURATION_FIELD);
        map.put("WebAuthnConfiguration", WEB_AUTHN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetUserPoolMfaConfigResponse, T> g) {
        return obj -> g.apply((SetUserPoolMfaConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private SmsMfaConfigType smsMfaConfiguration;
        private SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
        private EmailMfaConfigType emailMfaConfiguration;
        private String mfaConfiguration;
        private WebAuthnConfigurationType webAuthnConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserPoolMfaConfigResponse model) {
            super(model);
            this.smsMfaConfiguration(model.smsMfaConfiguration);
            this.softwareTokenMfaConfiguration(model.softwareTokenMfaConfiguration);
            this.emailMfaConfiguration(model.emailMfaConfiguration);
            this.mfaConfiguration(model.mfaConfiguration);
            this.webAuthnConfiguration(model.webAuthnConfiguration);
        }

        public final SmsMfaConfigType.Builder getSmsMfaConfiguration() {
            return this.smsMfaConfiguration != null ? this.smsMfaConfiguration.toBuilder() : null;
        }

        public final void setSmsMfaConfiguration(SmsMfaConfigType.BuilderImpl smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration != null ? smsMfaConfiguration.build() : null;
        }

        @Override
        public final Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration;
            return this;
        }

        public final SoftwareTokenMfaConfigType.Builder getSoftwareTokenMfaConfiguration() {
            return this.softwareTokenMfaConfiguration != null ? this.softwareTokenMfaConfiguration.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.BuilderImpl softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.build() : null;
        }

        @Override
        public final Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration;
            return this;
        }

        public final EmailMfaConfigType.Builder getEmailMfaConfiguration() {
            return this.emailMfaConfiguration != null ? this.emailMfaConfiguration.toBuilder() : null;
        }

        public final void setEmailMfaConfiguration(EmailMfaConfigType.BuilderImpl emailMfaConfiguration) {
            this.emailMfaConfiguration = emailMfaConfiguration != null ? emailMfaConfiguration.build() : null;
        }

        @Override
        public final Builder emailMfaConfiguration(EmailMfaConfigType emailMfaConfiguration) {
            this.emailMfaConfiguration = emailMfaConfiguration;
            return this;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final WebAuthnConfigurationType.Builder getWebAuthnConfiguration() {
            return this.webAuthnConfiguration != null ? this.webAuthnConfiguration.toBuilder() : null;
        }

        public final void setWebAuthnConfiguration(WebAuthnConfigurationType.BuilderImpl webAuthnConfiguration) {
            this.webAuthnConfiguration = webAuthnConfiguration != null ? webAuthnConfiguration.build() : null;
        }

        @Override
        public final Builder webAuthnConfiguration(WebAuthnConfigurationType webAuthnConfiguration) {
            this.webAuthnConfiguration = webAuthnConfiguration;
            return this;
        }

        @Override
        public SetUserPoolMfaConfigResponse build() {
            return new SetUserPoolMfaConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetUserPoolMfaConfigResponse> {
        public Builder smsMfaConfiguration(SmsMfaConfigType var1);

        default public Builder smsMfaConfiguration(Consumer<SmsMfaConfigType.Builder> smsMfaConfiguration) {
            return this.smsMfaConfiguration((SmsMfaConfigType)((SmsMfaConfigType.Builder)SmsMfaConfigType.builder().applyMutation(smsMfaConfiguration)).build());
        }

        public Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType var1);

        default public Builder softwareTokenMfaConfiguration(Consumer<SoftwareTokenMfaConfigType.Builder> softwareTokenMfaConfiguration) {
            return this.softwareTokenMfaConfiguration((SoftwareTokenMfaConfigType)((SoftwareTokenMfaConfigType.Builder)SoftwareTokenMfaConfigType.builder().applyMutation(softwareTokenMfaConfiguration)).build());
        }

        public Builder emailMfaConfiguration(EmailMfaConfigType var1);

        default public Builder emailMfaConfiguration(Consumer<EmailMfaConfigType.Builder> emailMfaConfiguration) {
            return this.emailMfaConfiguration((EmailMfaConfigType)((EmailMfaConfigType.Builder)EmailMfaConfigType.builder().applyMutation(emailMfaConfiguration)).build());
        }

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);

        public Builder webAuthnConfiguration(WebAuthnConfigurationType var1);

        default public Builder webAuthnConfiguration(Consumer<WebAuthnConfigurationType.Builder> webAuthnConfiguration) {
            return this.webAuthnConfiguration((WebAuthnConfigurationType)((WebAuthnConfigurationType.Builder)WebAuthnConfigurationType.builder().applyMutation(webAuthnConfiguration)).build());
        }
    }
}

