/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResult;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueFailureResultListCopier;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResult;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueSuccessResultListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateDataTableValueResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchUpdateDataTableValueResponse> {
    private static final SdkField<List<BatchUpdateDataTableValueSuccessResult>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchUpdateDataTableValueResponse.getter(BatchUpdateDataTableValueResponse::successful)).setter(BatchUpdateDataTableValueResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateDataTableValueSuccessResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateDataTableValueFailureResult>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchUpdateDataTableValueResponse.getter(BatchUpdateDataTableValueResponse::failed)).setter(BatchUpdateDataTableValueResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateDataTableValueFailureResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateDataTableValueResponse.memberNameToFieldInitializer();
    private final List<BatchUpdateDataTableValueSuccessResult> successful;
    private final List<BatchUpdateDataTableValueFailureResult> failed;

    private BatchUpdateDataTableValueResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateDataTableValueSuccessResult> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateDataTableValueFailureResult> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDataTableValueResponse)) {
            return false;
        }
        BatchUpdateDataTableValueResponse other = (BatchUpdateDataTableValueResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateDataTableValueResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDataTableValueResponse, T> g) {
        return obj -> g.apply((BatchUpdateDataTableValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<BatchUpdateDataTableValueSuccessResult> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateDataTableValueFailureResult> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDataTableValueResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final List<BatchUpdateDataTableValueSuccessResult.Builder> getSuccessful() {
            List<BatchUpdateDataTableValueSuccessResult.Builder> result = BatchUpdateDataTableValueSuccessResultListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<BatchUpdateDataTableValueSuccessResult.BuilderImpl> successful) {
            this.successful = BatchUpdateDataTableValueSuccessResultListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<BatchUpdateDataTableValueSuccessResult> successful) {
            this.successful = BatchUpdateDataTableValueSuccessResultListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchUpdateDataTableValueSuccessResult ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchUpdateDataTableValueSuccessResult.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (BatchUpdateDataTableValueSuccessResult)((BatchUpdateDataTableValueSuccessResult.Builder)BatchUpdateDataTableValueSuccessResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateDataTableValueFailureResult.Builder> getFailed() {
            List<BatchUpdateDataTableValueFailureResult.Builder> result = BatchUpdateDataTableValueFailureResultListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchUpdateDataTableValueFailureResult.BuilderImpl> failed) {
            this.failed = BatchUpdateDataTableValueFailureResultListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchUpdateDataTableValueFailureResult> failed) {
            this.failed = BatchUpdateDataTableValueFailureResultListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchUpdateDataTableValueFailureResult ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchUpdateDataTableValueFailureResult.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchUpdateDataTableValueFailureResult)((BatchUpdateDataTableValueFailureResult.Builder)BatchUpdateDataTableValueFailureResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateDataTableValueResponse build() {
            return new BatchUpdateDataTableValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateDataTableValueResponse> {
        public Builder successful(Collection<BatchUpdateDataTableValueSuccessResult> var1);

        public Builder successful(BatchUpdateDataTableValueSuccessResult ... var1);

        public Builder successful(Consumer<BatchUpdateDataTableValueSuccessResult.Builder> ... var1);

        public Builder failed(Collection<BatchUpdateDataTableValueFailureResult> var1);

        public Builder failed(BatchUpdateDataTableValueFailureResult ... var1);

        public Builder failed(Consumer<BatchUpdateDataTableValueFailureResult.Builder> ... var1);
    }
}

