/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.BooleanComparisonType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BooleanCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BooleanCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(BooleanCondition.getter(BooleanCondition::fieldName)).setter(BooleanCondition.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonType").getter(BooleanCondition.getter(BooleanCondition::comparisonTypeAsString)).setter(BooleanCondition.setter(Builder::comparisonType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, COMPARISON_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BooleanCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String comparisonType;

    private BooleanCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.comparisonType = builder.comparisonType;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final BooleanComparisonType comparisonType() {
        return BooleanComparisonType.fromValue(this.comparisonType);
    }

    public final String comparisonTypeAsString() {
        return this.comparisonType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanCondition)) {
            return false;
        }
        BooleanCondition other = (BooleanCondition)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BooleanCondition").add("FieldName", (Object)this.fieldName()).add("ComparisonType", (Object)this.comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "ComparisonType": {
                return Optional.ofNullable(clazz.cast(this.comparisonTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BooleanCondition, T> g) {
        return obj -> g.apply((BooleanCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanCondition model) {
            this.fieldName(model.fieldName);
            this.comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getComparisonType() {
            return this.comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(BooleanComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        public BooleanCondition build() {
            return new BooleanCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BooleanCondition> {
        public Builder fieldName(String var1);

        public Builder comparisonType(String var1);

        public Builder comparisonType(BooleanComparisonType var1);
    }
}

