/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatContactMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatContactMetrics> {
    private static final SdkField<Boolean> MULTI_PARTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiParty").getter(ChatContactMetrics.getter(ChatContactMetrics::multiParty)).setter(ChatContactMetrics.setter(Builder::multiParty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiParty").build()}).build();
    private static final SdkField<Integer> TOTAL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMessages").getter(ChatContactMetrics.getter(ChatContactMetrics::totalMessages)).setter(ChatContactMetrics.setter(Builder::totalMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMessages").build()}).build();
    private static final SdkField<Integer> TOTAL_BOT_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalBotMessages").getter(ChatContactMetrics.getter(ChatContactMetrics::totalBotMessages)).setter(ChatContactMetrics.setter(Builder::totalBotMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBotMessages").build()}).build();
    private static final SdkField<Integer> TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalBotMessageLengthInChars").getter(ChatContactMetrics.getter(ChatContactMetrics::totalBotMessageLengthInChars)).setter(ChatContactMetrics.setter(Builder::totalBotMessageLengthInChars)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBotMessageLengthInChars").build()}).build();
    private static final SdkField<Long> CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConversationCloseTimeInMillis").getter(ChatContactMetrics.getter(ChatContactMetrics::conversationCloseTimeInMillis)).setter(ChatContactMetrics.setter(Builder::conversationCloseTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationCloseTimeInMillis").build()}).build();
    private static final SdkField<Integer> CONVERSATION_TURN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConversationTurnCount").getter(ChatContactMetrics.getter(ChatContactMetrics::conversationTurnCount)).setter(ChatContactMetrics.setter(Builder::conversationTurnCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationTurnCount").build()}).build();
    private static final SdkField<Instant> AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AgentFirstResponseTimestamp").getter(ChatContactMetrics.getter(ChatContactMetrics::agentFirstResponseTimestamp)).setter(ChatContactMetrics.setter(Builder::agentFirstResponseTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentFirstResponseTimestamp").build()}).build();
    private static final SdkField<Long> AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AgentFirstResponseTimeInMillis").getter(ChatContactMetrics.getter(ChatContactMetrics::agentFirstResponseTimeInMillis)).setter(ChatContactMetrics.setter(Builder::agentFirstResponseTimeInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentFirstResponseTimeInMillis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_PARTY_FIELD, TOTAL_MESSAGES_FIELD, TOTAL_BOT_MESSAGES_FIELD, TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD, CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD, CONVERSATION_TURN_COUNT_FIELD, AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD, AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatContactMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean multiParty;
    private final Integer totalMessages;
    private final Integer totalBotMessages;
    private final Integer totalBotMessageLengthInChars;
    private final Long conversationCloseTimeInMillis;
    private final Integer conversationTurnCount;
    private final Instant agentFirstResponseTimestamp;
    private final Long agentFirstResponseTimeInMillis;

    private ChatContactMetrics(BuilderImpl builder) {
        this.multiParty = builder.multiParty;
        this.totalMessages = builder.totalMessages;
        this.totalBotMessages = builder.totalBotMessages;
        this.totalBotMessageLengthInChars = builder.totalBotMessageLengthInChars;
        this.conversationCloseTimeInMillis = builder.conversationCloseTimeInMillis;
        this.conversationTurnCount = builder.conversationTurnCount;
        this.agentFirstResponseTimestamp = builder.agentFirstResponseTimestamp;
        this.agentFirstResponseTimeInMillis = builder.agentFirstResponseTimeInMillis;
    }

    public final Boolean multiParty() {
        return this.multiParty;
    }

    public final Integer totalMessages() {
        return this.totalMessages;
    }

    public final Integer totalBotMessages() {
        return this.totalBotMessages;
    }

    public final Integer totalBotMessageLengthInChars() {
        return this.totalBotMessageLengthInChars;
    }

    public final Long conversationCloseTimeInMillis() {
        return this.conversationCloseTimeInMillis;
    }

    public final Integer conversationTurnCount() {
        return this.conversationTurnCount;
    }

    public final Instant agentFirstResponseTimestamp() {
        return this.agentFirstResponseTimestamp;
    }

    public final Long agentFirstResponseTimeInMillis() {
        return this.agentFirstResponseTimeInMillis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multiParty());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMessages());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBotMessages());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBotMessageLengthInChars());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationCloseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationTurnCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentFirstResponseTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentFirstResponseTimeInMillis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatContactMetrics)) {
            return false;
        }
        ChatContactMetrics other = (ChatContactMetrics)obj;
        return Objects.equals(this.multiParty(), other.multiParty()) && Objects.equals(this.totalMessages(), other.totalMessages()) && Objects.equals(this.totalBotMessages(), other.totalBotMessages()) && Objects.equals(this.totalBotMessageLengthInChars(), other.totalBotMessageLengthInChars()) && Objects.equals(this.conversationCloseTimeInMillis(), other.conversationCloseTimeInMillis()) && Objects.equals(this.conversationTurnCount(), other.conversationTurnCount()) && Objects.equals(this.agentFirstResponseTimestamp(), other.agentFirstResponseTimestamp()) && Objects.equals(this.agentFirstResponseTimeInMillis(), other.agentFirstResponseTimeInMillis());
    }

    public final String toString() {
        return ToString.builder((String)"ChatContactMetrics").add("MultiParty", (Object)this.multiParty()).add("TotalMessages", (Object)this.totalMessages()).add("TotalBotMessages", (Object)this.totalBotMessages()).add("TotalBotMessageLengthInChars", (Object)this.totalBotMessageLengthInChars()).add("ConversationCloseTimeInMillis", (Object)this.conversationCloseTimeInMillis()).add("ConversationTurnCount", (Object)this.conversationTurnCount()).add("AgentFirstResponseTimestamp", (Object)this.agentFirstResponseTimestamp()).add("AgentFirstResponseTimeInMillis", (Object)this.agentFirstResponseTimeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiParty": {
                return Optional.ofNullable(clazz.cast(this.multiParty()));
            }
            case "TotalMessages": {
                return Optional.ofNullable(clazz.cast(this.totalMessages()));
            }
            case "TotalBotMessages": {
                return Optional.ofNullable(clazz.cast(this.totalBotMessages()));
            }
            case "TotalBotMessageLengthInChars": {
                return Optional.ofNullable(clazz.cast(this.totalBotMessageLengthInChars()));
            }
            case "ConversationCloseTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.conversationCloseTimeInMillis()));
            }
            case "ConversationTurnCount": {
                return Optional.ofNullable(clazz.cast(this.conversationTurnCount()));
            }
            case "AgentFirstResponseTimestamp": {
                return Optional.ofNullable(clazz.cast(this.agentFirstResponseTimestamp()));
            }
            case "AgentFirstResponseTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.agentFirstResponseTimeInMillis()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MultiParty", MULTI_PARTY_FIELD);
        map.put("TotalMessages", TOTAL_MESSAGES_FIELD);
        map.put("TotalBotMessages", TOTAL_BOT_MESSAGES_FIELD);
        map.put("TotalBotMessageLengthInChars", TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD);
        map.put("ConversationCloseTimeInMillis", CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD);
        map.put("ConversationTurnCount", CONVERSATION_TURN_COUNT_FIELD);
        map.put("AgentFirstResponseTimestamp", AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD);
        map.put("AgentFirstResponseTimeInMillis", AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatContactMetrics, T> g) {
        return obj -> g.apply((ChatContactMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean multiParty;
        private Integer totalMessages;
        private Integer totalBotMessages;
        private Integer totalBotMessageLengthInChars;
        private Long conversationCloseTimeInMillis;
        private Integer conversationTurnCount;
        private Instant agentFirstResponseTimestamp;
        private Long agentFirstResponseTimeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatContactMetrics model) {
            this.multiParty(model.multiParty);
            this.totalMessages(model.totalMessages);
            this.totalBotMessages(model.totalBotMessages);
            this.totalBotMessageLengthInChars(model.totalBotMessageLengthInChars);
            this.conversationCloseTimeInMillis(model.conversationCloseTimeInMillis);
            this.conversationTurnCount(model.conversationTurnCount);
            this.agentFirstResponseTimestamp(model.agentFirstResponseTimestamp);
            this.agentFirstResponseTimeInMillis(model.agentFirstResponseTimeInMillis);
        }

        public final Boolean getMultiParty() {
            return this.multiParty;
        }

        public final void setMultiParty(Boolean multiParty) {
            this.multiParty = multiParty;
        }

        @Override
        public final Builder multiParty(Boolean multiParty) {
            this.multiParty = multiParty;
            return this;
        }

        public final Integer getTotalMessages() {
            return this.totalMessages;
        }

        public final void setTotalMessages(Integer totalMessages) {
            this.totalMessages = totalMessages;
        }

        @Override
        public final Builder totalMessages(Integer totalMessages) {
            this.totalMessages = totalMessages;
            return this;
        }

        public final Integer getTotalBotMessages() {
            return this.totalBotMessages;
        }

        public final void setTotalBotMessages(Integer totalBotMessages) {
            this.totalBotMessages = totalBotMessages;
        }

        @Override
        public final Builder totalBotMessages(Integer totalBotMessages) {
            this.totalBotMessages = totalBotMessages;
            return this;
        }

        public final Integer getTotalBotMessageLengthInChars() {
            return this.totalBotMessageLengthInChars;
        }

        public final void setTotalBotMessageLengthInChars(Integer totalBotMessageLengthInChars) {
            this.totalBotMessageLengthInChars = totalBotMessageLengthInChars;
        }

        @Override
        public final Builder totalBotMessageLengthInChars(Integer totalBotMessageLengthInChars) {
            this.totalBotMessageLengthInChars = totalBotMessageLengthInChars;
            return this;
        }

        public final Long getConversationCloseTimeInMillis() {
            return this.conversationCloseTimeInMillis;
        }

        public final void setConversationCloseTimeInMillis(Long conversationCloseTimeInMillis) {
            this.conversationCloseTimeInMillis = conversationCloseTimeInMillis;
        }

        @Override
        public final Builder conversationCloseTimeInMillis(Long conversationCloseTimeInMillis) {
            this.conversationCloseTimeInMillis = conversationCloseTimeInMillis;
            return this;
        }

        public final Integer getConversationTurnCount() {
            return this.conversationTurnCount;
        }

        public final void setConversationTurnCount(Integer conversationTurnCount) {
            this.conversationTurnCount = conversationTurnCount;
        }

        @Override
        public final Builder conversationTurnCount(Integer conversationTurnCount) {
            this.conversationTurnCount = conversationTurnCount;
            return this;
        }

        public final Instant getAgentFirstResponseTimestamp() {
            return this.agentFirstResponseTimestamp;
        }

        public final void setAgentFirstResponseTimestamp(Instant agentFirstResponseTimestamp) {
            this.agentFirstResponseTimestamp = agentFirstResponseTimestamp;
        }

        @Override
        public final Builder agentFirstResponseTimestamp(Instant agentFirstResponseTimestamp) {
            this.agentFirstResponseTimestamp = agentFirstResponseTimestamp;
            return this;
        }

        public final Long getAgentFirstResponseTimeInMillis() {
            return this.agentFirstResponseTimeInMillis;
        }

        public final void setAgentFirstResponseTimeInMillis(Long agentFirstResponseTimeInMillis) {
            this.agentFirstResponseTimeInMillis = agentFirstResponseTimeInMillis;
        }

        @Override
        public final Builder agentFirstResponseTimeInMillis(Long agentFirstResponseTimeInMillis) {
            this.agentFirstResponseTimeInMillis = agentFirstResponseTimeInMillis;
            return this;
        }

        public ChatContactMetrics build() {
            return new ChatContactMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatContactMetrics> {
        public Builder multiParty(Boolean var1);

        public Builder totalMessages(Integer var1);

        public Builder totalBotMessages(Integer var1);

        public Builder totalBotMessageLengthInChars(Integer var1);

        public Builder conversationCloseTimeInMillis(Long var1);

        public Builder conversationTurnCount(Integer var1);

        public Builder agentFirstResponseTimestamp(Instant var1);

        public Builder agentFirstResponseTimeInMillis(Long var1);
    }
}

