/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.Campaign;
import software.amazon.awssdk.services.connect.model.Endpoint;
import software.amazon.awssdk.services.connect.model.OutboundStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactDataRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactDataRequest> {
    private static final SdkField<Endpoint> SYSTEM_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SystemEndpoint").getter(ContactDataRequest.getter(ContactDataRequest::systemEndpoint)).setter(ContactDataRequest.setter(Builder::systemEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemEndpoint").build()}).build();
    private static final SdkField<Endpoint> CUSTOMER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerEndpoint").getter(ContactDataRequest.getter(ContactDataRequest::customerEndpoint)).setter(ContactDataRequest.setter(Builder::customerEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEndpoint").build()}).build();
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestIdentifier").getter(ContactDataRequest.getter(ContactDataRequest::requestIdentifier)).setter(ContactDataRequest.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(ContactDataRequest.getter(ContactDataRequest::queueId)).setter(ContactDataRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(ContactDataRequest.getter(ContactDataRequest::attributes)).setter(ContactDataRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Campaign> CAMPAIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Campaign").getter(ContactDataRequest.getter(ContactDataRequest::campaign)).setter(ContactDataRequest.setter(Builder::campaign)).constructor(Campaign::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Campaign").build()}).build();
    private static final SdkField<OutboundStrategy> OUTBOUND_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutboundStrategy").getter(ContactDataRequest.getter(ContactDataRequest::outboundStrategy)).setter(ContactDataRequest.setter(Builder::outboundStrategy)).constructor(OutboundStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ENDPOINT_FIELD, CUSTOMER_ENDPOINT_FIELD, REQUEST_IDENTIFIER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD, CAMPAIGN_FIELD, OUTBOUND_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactDataRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Endpoint systemEndpoint;
    private final Endpoint customerEndpoint;
    private final String requestIdentifier;
    private final String queueId;
    private final Map<String, String> attributes;
    private final Campaign campaign;
    private final OutboundStrategy outboundStrategy;

    private ContactDataRequest(BuilderImpl builder) {
        this.systemEndpoint = builder.systemEndpoint;
        this.customerEndpoint = builder.customerEndpoint;
        this.requestIdentifier = builder.requestIdentifier;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
        this.campaign = builder.campaign;
        this.outboundStrategy = builder.outboundStrategy;
    }

    public final Endpoint systemEndpoint() {
        return this.systemEndpoint;
    }

    public final Endpoint customerEndpoint() {
        return this.customerEndpoint;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final Campaign campaign() {
        return this.campaign;
    }

    public final OutboundStrategy outboundStrategy() {
        return this.outboundStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.campaign());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDataRequest)) {
            return false;
        }
        ContactDataRequest other = (ContactDataRequest)obj;
        return Objects.equals(this.systemEndpoint(), other.systemEndpoint()) && Objects.equals(this.customerEndpoint(), other.customerEndpoint()) && Objects.equals(this.requestIdentifier(), other.requestIdentifier()) && Objects.equals(this.queueId(), other.queueId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.campaign(), other.campaign()) && Objects.equals(this.outboundStrategy(), other.outboundStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"ContactDataRequest").add("SystemEndpoint", (Object)this.systemEndpoint()).add("CustomerEndpoint", (Object)this.customerEndpoint()).add("RequestIdentifier", (Object)this.requestIdentifier()).add("QueueId", (Object)this.queueId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Campaign", (Object)this.campaign()).add("OutboundStrategy", (Object)this.outboundStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SystemEndpoint": {
                return Optional.ofNullable(clazz.cast(this.systemEndpoint()));
            }
            case "CustomerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.customerEndpoint()));
            }
            case "RequestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Campaign": {
                return Optional.ofNullable(clazz.cast(this.campaign()));
            }
            case "OutboundStrategy": {
                return Optional.ofNullable(clazz.cast(this.outboundStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SystemEndpoint", SYSTEM_ENDPOINT_FIELD);
        map.put("CustomerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Campaign", CAMPAIGN_FIELD);
        map.put("OutboundStrategy", OUTBOUND_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactDataRequest, T> g) {
        return obj -> g.apply((ContactDataRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Endpoint systemEndpoint;
        private Endpoint customerEndpoint;
        private String requestIdentifier;
        private String queueId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Campaign campaign;
        private OutboundStrategy outboundStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDataRequest model) {
            this.systemEndpoint(model.systemEndpoint);
            this.customerEndpoint(model.customerEndpoint);
            this.requestIdentifier(model.requestIdentifier);
            this.queueId(model.queueId);
            this.attributes(model.attributes);
            this.campaign(model.campaign);
            this.outboundStrategy(model.outboundStrategy);
        }

        public final Endpoint.Builder getSystemEndpoint() {
            return this.systemEndpoint != null ? this.systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(Endpoint.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(Endpoint systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        public final Endpoint.Builder getCustomerEndpoint() {
            return this.customerEndpoint != null ? this.customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(Endpoint.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(Endpoint customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Campaign.Builder getCampaign() {
            return this.campaign != null ? this.campaign.toBuilder() : null;
        }

        public final void setCampaign(Campaign.BuilderImpl campaign) {
            this.campaign = campaign != null ? campaign.build() : null;
        }

        @Override
        public final Builder campaign(Campaign campaign) {
            this.campaign = campaign;
            return this;
        }

        public final OutboundStrategy.Builder getOutboundStrategy() {
            return this.outboundStrategy != null ? this.outboundStrategy.toBuilder() : null;
        }

        public final void setOutboundStrategy(OutboundStrategy.BuilderImpl outboundStrategy) {
            this.outboundStrategy = outboundStrategy != null ? outboundStrategy.build() : null;
        }

        @Override
        public final Builder outboundStrategy(OutboundStrategy outboundStrategy) {
            this.outboundStrategy = outboundStrategy;
            return this;
        }

        public ContactDataRequest build() {
            return new ContactDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactDataRequest> {
        public Builder systemEndpoint(Endpoint var1);

        default public Builder systemEndpoint(Consumer<Endpoint.Builder> systemEndpoint) {
            return this.systemEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(systemEndpoint)).build());
        }

        public Builder customerEndpoint(Endpoint var1);

        default public Builder customerEndpoint(Consumer<Endpoint.Builder> customerEndpoint) {
            return this.customerEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(customerEndpoint)).build());
        }

        public Builder requestIdentifier(String var1);

        public Builder queueId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder campaign(Campaign var1);

        default public Builder campaign(Consumer<Campaign.Builder> campaign) {
            return this.campaign((Campaign)((Campaign.Builder)Campaign.builder().applyMutation(campaign)).build());
        }

        public Builder outboundStrategy(OutboundStrategy var1);

        default public Builder outboundStrategy(Consumer<OutboundStrategy.Builder> outboundStrategy) {
            return this.outboundStrategy((OutboundStrategy)((OutboundStrategy.Builder)OutboundStrategy.builder().applyMutation(outboundStrategy)).build());
        }
    }
}

