/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ContactFlowAttributeAndCondition;
import software.amazon.awssdk.services.connect.model.ContactFlowAttributeOrConditionListCopier;
import software.amazon.awssdk.services.connect.model.ContactFlowTypeCondition;
import software.amazon.awssdk.services.connect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFlowAttributeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFlowAttributeFilter> {
    private static final SdkField<List<ContactFlowAttributeAndCondition>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ContactFlowAttributeFilter.getter(ContactFlowAttributeFilter::orConditions)).setter(ContactFlowAttributeFilter.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowAttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContactFlowAttributeAndCondition> AND_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AndCondition").getter(ContactFlowAttributeFilter.getter(ContactFlowAttributeFilter::andCondition)).setter(ContactFlowAttributeFilter.setter(Builder::andCondition)).constructor(ContactFlowAttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndCondition").build()}).build();
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagCondition").getter(ContactFlowAttributeFilter.getter(ContactFlowAttributeFilter::tagCondition)).setter(ContactFlowAttributeFilter.setter(Builder::tagCondition)).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()}).build();
    private static final SdkField<ContactFlowTypeCondition> CONTACT_FLOW_TYPE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactFlowTypeCondition").getter(ContactFlowAttributeFilter.getter(ContactFlowAttributeFilter::contactFlowTypeCondition)).setter(ContactFlowAttributeFilter.setter(Builder::contactFlowTypeCondition)).constructor(ContactFlowTypeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowTypeCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITION_FIELD, TAG_CONDITION_FIELD, CONTACT_FLOW_TYPE_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactFlowAttributeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ContactFlowAttributeAndCondition> orConditions;
    private final ContactFlowAttributeAndCondition andCondition;
    private final TagCondition tagCondition;
    private final ContactFlowTypeCondition contactFlowTypeCondition;

    private ContactFlowAttributeFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andCondition = builder.andCondition;
        this.tagCondition = builder.tagCondition;
        this.contactFlowTypeCondition = builder.contactFlowTypeCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowAttributeAndCondition> orConditions() {
        return this.orConditions;
    }

    public final ContactFlowAttributeAndCondition andCondition() {
        return this.andCondition;
    }

    public final TagCondition tagCondition() {
        return this.tagCondition;
    }

    public final ContactFlowTypeCondition contactFlowTypeCondition() {
        return this.contactFlowTypeCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.andCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowTypeCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowAttributeFilter)) {
            return false;
        }
        ContactFlowAttributeFilter other = (ContactFlowAttributeFilter)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && Objects.equals(this.andCondition(), other.andCondition()) && Objects.equals(this.tagCondition(), other.tagCondition()) && Objects.equals(this.contactFlowTypeCondition(), other.contactFlowTypeCondition());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFlowAttributeFilter").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndCondition", (Object)this.andCondition()).add("TagCondition", (Object)this.tagCondition()).add("ContactFlowTypeCondition", (Object)this.contactFlowTypeCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndCondition": {
                return Optional.ofNullable(clazz.cast(this.andCondition()));
            }
            case "TagCondition": {
                return Optional.ofNullable(clazz.cast(this.tagCondition()));
            }
            case "ContactFlowTypeCondition": {
                return Optional.ofNullable(clazz.cast(this.contactFlowTypeCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndCondition", AND_CONDITION_FIELD);
        map.put("TagCondition", TAG_CONDITION_FIELD);
        map.put("ContactFlowTypeCondition", CONTACT_FLOW_TYPE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowAttributeFilter, T> g) {
        return obj -> g.apply((ContactFlowAttributeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContactFlowAttributeAndCondition> orConditions = DefaultSdkAutoConstructList.getInstance();
        private ContactFlowAttributeAndCondition andCondition;
        private TagCondition tagCondition;
        private ContactFlowTypeCondition contactFlowTypeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowAttributeFilter model) {
            this.orConditions(model.orConditions);
            this.andCondition(model.andCondition);
            this.tagCondition(model.tagCondition);
            this.contactFlowTypeCondition(model.contactFlowTypeCondition);
        }

        public final List<ContactFlowAttributeAndCondition.Builder> getOrConditions() {
            List<ContactFlowAttributeAndCondition.Builder> result = ContactFlowAttributeOrConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<ContactFlowAttributeAndCondition.BuilderImpl> orConditions) {
            this.orConditions = ContactFlowAttributeOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ContactFlowAttributeAndCondition> orConditions) {
            this.orConditions = ContactFlowAttributeOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ContactFlowAttributeAndCondition ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<ContactFlowAttributeAndCondition.Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (ContactFlowAttributeAndCondition)((ContactFlowAttributeAndCondition.Builder)ContactFlowAttributeAndCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ContactFlowAttributeAndCondition.Builder getAndCondition() {
            return this.andCondition != null ? this.andCondition.toBuilder() : null;
        }

        public final void setAndCondition(ContactFlowAttributeAndCondition.BuilderImpl andCondition) {
            this.andCondition = andCondition != null ? andCondition.build() : null;
        }

        @Override
        public final Builder andCondition(ContactFlowAttributeAndCondition andCondition) {
            this.andCondition = andCondition;
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return this.tagCondition != null ? this.tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        public final ContactFlowTypeCondition.Builder getContactFlowTypeCondition() {
            return this.contactFlowTypeCondition != null ? this.contactFlowTypeCondition.toBuilder() : null;
        }

        public final void setContactFlowTypeCondition(ContactFlowTypeCondition.BuilderImpl contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition != null ? contactFlowTypeCondition.build() : null;
        }

        @Override
        public final Builder contactFlowTypeCondition(ContactFlowTypeCondition contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition;
            return this;
        }

        public ContactFlowAttributeFilter build() {
            return new ContactFlowAttributeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFlowAttributeFilter> {
        public Builder orConditions(Collection<ContactFlowAttributeAndCondition> var1);

        public Builder orConditions(ContactFlowAttributeAndCondition ... var1);

        public Builder orConditions(Consumer<ContactFlowAttributeAndCondition.Builder> ... var1);

        public Builder andCondition(ContactFlowAttributeAndCondition var1);

        default public Builder andCondition(Consumer<ContactFlowAttributeAndCondition.Builder> andCondition) {
            return this.andCondition((ContactFlowAttributeAndCondition)((ContactFlowAttributeAndCondition.Builder)ContactFlowAttributeAndCondition.builder().applyMutation(andCondition)).build());
        }

        public Builder tagCondition(TagCondition var1);

        default public Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return this.tagCondition((TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation(tagCondition)).build());
        }

        public Builder contactFlowTypeCondition(ContactFlowTypeCondition var1);

        default public Builder contactFlowTypeCondition(Consumer<ContactFlowTypeCondition.Builder> contactFlowTypeCondition) {
            return this.contactFlowTypeCondition((ContactFlowTypeCondition)((ContactFlowTypeCondition.Builder)ContactFlowTypeCondition.builder().applyMutation(contactFlowTypeCondition)).build());
        }
    }
}

