/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactMetricName {
    POSITION_IN_QUEUE("POSITION_IN_QUEUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactMetricName> VALUE_MAP;
    private final String value;

    private ContactMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactMetricName> knownValues() {
        EnumSet<ContactMetricName> knownValues = EnumSet.allOf(ContactMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactMetricName.class, ContactMetricName::toString);
    }
}

