/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactState {
    INCOMING("INCOMING"),
    PENDING("PENDING"),
    CONNECTING("CONNECTING"),
    CONNECTED("CONNECTED"),
    CONNECTED_ONHOLD("CONNECTED_ONHOLD"),
    MISSED("MISSED"),
    ERROR("ERROR"),
    ENDED("ENDED"),
    REJECTED("REJECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactState> VALUE_MAP;
    private final String value;

    private ContactState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactState> knownValues() {
        EnumSet<ContactState> knownValues = EnumSet.allOf(ContactState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactState.class, ContactState::toString);
    }
}

