/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataTableAttributeValueType {
    TEXT("TEXT"),
    NUMBER("NUMBER"),
    BOOLEAN("BOOLEAN"),
    TEXT_LIST("TEXT_LIST"),
    NUMBER_LIST("NUMBER_LIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataTableAttributeValueType> VALUE_MAP;
    private final String value;

    private DataTableAttributeValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataTableAttributeValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataTableAttributeValueType> knownValues() {
        EnumSet<DataTableAttributeValueType> knownValues = EnumSet.allOf(DataTableAttributeValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataTableAttributeValueType.class, DataTableAttributeValueType::toString);
    }
}

