/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationAnswerData;
import software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswer;
import software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationAnswerOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationAnswerOutput> {
    private static final SdkField<EvaluationAnswerData> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(EvaluationAnswerOutput.getter(EvaluationAnswerOutput::value)).setter(EvaluationAnswerOutput.setter(Builder::value)).constructor(EvaluationAnswerData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<EvaluationAnswerData> SYSTEM_SUGGESTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SystemSuggestedValue").getter(EvaluationAnswerOutput.getter(EvaluationAnswerOutput::systemSuggestedValue)).setter(EvaluationAnswerOutput.setter(Builder::systemSuggestedValue)).constructor(EvaluationAnswerData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemSuggestedValue").build()}).build();
    private static final SdkField<List<EvaluationSuggestedAnswer>> SUGGESTED_ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestedAnswers").getter(EvaluationAnswerOutput.getter(EvaluationAnswerOutput::suggestedAnswers)).setter(EvaluationAnswerOutput.setter(Builder::suggestedAnswers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedAnswers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationSuggestedAnswer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, SYSTEM_SUGGESTED_VALUE_FIELD, SUGGESTED_ANSWERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationAnswerOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationAnswerData value;
    private final EvaluationAnswerData systemSuggestedValue;
    private final List<EvaluationSuggestedAnswer> suggestedAnswers;

    private EvaluationAnswerOutput(BuilderImpl builder) {
        this.value = builder.value;
        this.systemSuggestedValue = builder.systemSuggestedValue;
        this.suggestedAnswers = builder.suggestedAnswers;
    }

    public final EvaluationAnswerData value() {
        return this.value;
    }

    public final EvaluationAnswerData systemSuggestedValue() {
        return this.systemSuggestedValue;
    }

    public final boolean hasSuggestedAnswers() {
        return this.suggestedAnswers != null && !(this.suggestedAnswers instanceof SdkAutoConstructList);
    }

    public final List<EvaluationSuggestedAnswer> suggestedAnswers() {
        return this.suggestedAnswers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemSuggestedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestedAnswers() ? this.suggestedAnswers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerOutput)) {
            return false;
        }
        EvaluationAnswerOutput other = (EvaluationAnswerOutput)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.systemSuggestedValue(), other.systemSuggestedValue()) && this.hasSuggestedAnswers() == other.hasSuggestedAnswers() && Objects.equals(this.suggestedAnswers(), other.suggestedAnswers());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationAnswerOutput").add("Value", (Object)this.value()).add("SystemSuggestedValue", (Object)this.systemSuggestedValue()).add("SuggestedAnswers", this.hasSuggestedAnswers() ? this.suggestedAnswers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "SystemSuggestedValue": {
                return Optional.ofNullable(clazz.cast(this.systemSuggestedValue()));
            }
            case "SuggestedAnswers": {
                return Optional.ofNullable(clazz.cast(this.suggestedAnswers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("SystemSuggestedValue", SYSTEM_SUGGESTED_VALUE_FIELD);
        map.put("SuggestedAnswers", SUGGESTED_ANSWERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerOutput, T> g) {
        return obj -> g.apply((EvaluationAnswerOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationAnswerData value;
        private EvaluationAnswerData systemSuggestedValue;
        private List<EvaluationSuggestedAnswer> suggestedAnswers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerOutput model) {
            this.value(model.value);
            this.systemSuggestedValue(model.systemSuggestedValue);
            this.suggestedAnswers(model.suggestedAnswers);
        }

        public final EvaluationAnswerData.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(EvaluationAnswerData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EvaluationAnswerData value) {
            this.value = value;
            return this;
        }

        public final EvaluationAnswerData.Builder getSystemSuggestedValue() {
            return this.systemSuggestedValue != null ? this.systemSuggestedValue.toBuilder() : null;
        }

        public final void setSystemSuggestedValue(EvaluationAnswerData.BuilderImpl systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue != null ? systemSuggestedValue.build() : null;
        }

        @Override
        public final Builder systemSuggestedValue(EvaluationAnswerData systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue;
            return this;
        }

        public final List<EvaluationSuggestedAnswer.Builder> getSuggestedAnswers() {
            List<EvaluationSuggestedAnswer.Builder> result = EvaluationSuggestedAnswersListCopier.copyToBuilder(this.suggestedAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedAnswers(Collection<EvaluationSuggestedAnswer.BuilderImpl> suggestedAnswers) {
            this.suggestedAnswers = EvaluationSuggestedAnswersListCopier.copyFromBuilder(suggestedAnswers);
        }

        @Override
        public final Builder suggestedAnswers(Collection<EvaluationSuggestedAnswer> suggestedAnswers) {
            this.suggestedAnswers = EvaluationSuggestedAnswersListCopier.copy(suggestedAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedAnswers(EvaluationSuggestedAnswer ... suggestedAnswers) {
            this.suggestedAnswers(Arrays.asList(suggestedAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedAnswers(Consumer<EvaluationSuggestedAnswer.Builder> ... suggestedAnswers) {
            this.suggestedAnswers(Stream.of(suggestedAnswers).map(c -> (EvaluationSuggestedAnswer)((EvaluationSuggestedAnswer.Builder)EvaluationSuggestedAnswer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationAnswerOutput build() {
            return new EvaluationAnswerOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationAnswerOutput> {
        public Builder value(EvaluationAnswerData var1);

        default public Builder value(Consumer<EvaluationAnswerData.Builder> value) {
            return this.value((EvaluationAnswerData)((EvaluationAnswerData.Builder)EvaluationAnswerData.builder().applyMutation(value)).build());
        }

        public Builder systemSuggestedValue(EvaluationAnswerData var1);

        default public Builder systemSuggestedValue(Consumer<EvaluationAnswerData.Builder> systemSuggestedValue) {
            return this.systemSuggestedValue((EvaluationAnswerData)((EvaluationAnswerData.Builder)EvaluationAnswerData.builder().applyMutation(systemSuggestedValue)).build());
        }

        public Builder suggestedAnswers(Collection<EvaluationSuggestedAnswer> var1);

        public Builder suggestedAnswers(EvaluationSuggestedAnswer ... var1);

        public Builder suggestedAnswers(Consumer<EvaluationSuggestedAnswer.Builder> ... var1);
    }
}

