/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest;
import software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointsOfInterestCopier;
import software.amazon.awssdk.services.connect.model.QuestionRuleCategoryAutomationCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationAutomationRuleCategory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationAutomationRuleCategory> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(EvaluationAutomationRuleCategory.getter(EvaluationAutomationRuleCategory::category)).setter(EvaluationAutomationRuleCategory.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Condition").getter(EvaluationAutomationRuleCategory.getter(EvaluationAutomationRuleCategory::conditionAsString)).setter(EvaluationAutomationRuleCategory.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<List<EvaluationTranscriptPointOfInterest>> POINTS_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PointsOfInterest").getter(EvaluationAutomationRuleCategory.getter(EvaluationAutomationRuleCategory::pointsOfInterest)).setter(EvaluationAutomationRuleCategory.setter(Builder::pointsOfInterest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointsOfInterest").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationTranscriptPointOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, CONDITION_FIELD, POINTS_OF_INTEREST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationAutomationRuleCategory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String condition;
    private final List<EvaluationTranscriptPointOfInterest> pointsOfInterest;

    private EvaluationAutomationRuleCategory(BuilderImpl builder) {
        this.category = builder.category;
        this.condition = builder.condition;
        this.pointsOfInterest = builder.pointsOfInterest;
    }

    public final String category() {
        return this.category;
    }

    public final QuestionRuleCategoryAutomationCondition condition() {
        return QuestionRuleCategoryAutomationCondition.fromValue(this.condition);
    }

    public final String conditionAsString() {
        return this.condition;
    }

    public final boolean hasPointsOfInterest() {
        return this.pointsOfInterest != null && !(this.pointsOfInterest instanceof SdkAutoConstructList);
    }

    public final List<EvaluationTranscriptPointOfInterest> pointsOfInterest() {
        return this.pointsOfInterest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPointsOfInterest() ? this.pointsOfInterest() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAutomationRuleCategory)) {
            return false;
        }
        EvaluationAutomationRuleCategory other = (EvaluationAutomationRuleCategory)obj;
        return Objects.equals(this.category(), other.category()) && Objects.equals(this.conditionAsString(), other.conditionAsString()) && this.hasPointsOfInterest() == other.hasPointsOfInterest() && Objects.equals(this.pointsOfInterest(), other.pointsOfInterest());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationAutomationRuleCategory").add("Category", (Object)this.category()).add("Condition", (Object)this.conditionAsString()).add("PointsOfInterest", this.hasPointsOfInterest() ? this.pointsOfInterest() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.conditionAsString()));
            }
            case "PointsOfInterest": {
                return Optional.ofNullable(clazz.cast(this.pointsOfInterest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("PointsOfInterest", POINTS_OF_INTEREST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAutomationRuleCategory, T> g) {
        return obj -> g.apply((EvaluationAutomationRuleCategory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String condition;
        private List<EvaluationTranscriptPointOfInterest> pointsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAutomationRuleCategory model) {
            this.category(model.category);
            this.condition(model.condition);
            this.pointsOfInterest(model.pointsOfInterest);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(QuestionRuleCategoryAutomationCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final List<EvaluationTranscriptPointOfInterest.Builder> getPointsOfInterest() {
            List<EvaluationTranscriptPointOfInterest.Builder> result = EvaluationTranscriptPointsOfInterestCopier.copyToBuilder(this.pointsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPointsOfInterest(Collection<EvaluationTranscriptPointOfInterest.BuilderImpl> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copyFromBuilder(pointsOfInterest);
        }

        @Override
        public final Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copy(pointsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(EvaluationTranscriptPointOfInterest ... pointsOfInterest) {
            this.pointsOfInterest(Arrays.asList(pointsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder> ... pointsOfInterest) {
            this.pointsOfInterest(Stream.of(pointsOfInterest).map(c -> (EvaluationTranscriptPointOfInterest)((EvaluationTranscriptPointOfInterest.Builder)EvaluationTranscriptPointOfInterest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluationAutomationRuleCategory build() {
            return new EvaluationAutomationRuleCategory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationAutomationRuleCategory> {
        public Builder category(String var1);

        public Builder condition(String var1);

        public Builder condition(QuestionRuleCategoryAutomationCondition var1);

        public Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> var1);

        public Builder pointsOfInterest(EvaluationTranscriptPointOfInterest ... var1);

        public Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder> ... var1);
    }
}

