/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationSearchMetadata;
import software.amazon.awssdk.services.connect.model.EvaluationStatus;
import software.amazon.awssdk.services.connect.model.EvaluationType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationSearchSummary> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationId)).setter(EvaluationSearchSummary.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationArn").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationArn)).setter(EvaluationSearchSummary.setter(Builder::evaluationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationFormId)).setter(EvaluationSearchSummary.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationFormVersion").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationFormVersion)).setter(EvaluationSearchSummary.setter(Builder::evaluationFormVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormTitle").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationFormTitle)).setter(EvaluationSearchSummary.setter(Builder::evaluationFormTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormTitle").build()}).build();
    private static final SdkField<EvaluationSearchMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::metadata)).setter(EvaluationSearchSummary.setter(Builder::metadata)).constructor(EvaluationSearchMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::statusAsString)).setter(EvaluationSearchSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::evaluationTypeAsString)).setter(EvaluationSearchSummary.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::createdTime)).setter(EvaluationSearchSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::lastModifiedTime)).setter(EvaluationSearchSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EvaluationSearchSummary.getter(EvaluationSearchSummary::tags)).setter(EvaluationSearchSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD, EVALUATION_ARN_FIELD, EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD, EVALUATION_FORM_TITLE_FIELD, METADATA_FIELD, STATUS_FIELD, EVALUATION_TYPE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationId;
    private final String evaluationArn;
    private final String evaluationFormId;
    private final Integer evaluationFormVersion;
    private final String evaluationFormTitle;
    private final EvaluationSearchMetadata metadata;
    private final String status;
    private final String evaluationType;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final Map<String, String> tags;

    private EvaluationSearchSummary(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.evaluationFormTitle = builder.evaluationFormTitle;
        this.metadata = builder.metadata;
        this.status = builder.status;
        this.evaluationType = builder.evaluationType;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final String evaluationArn() {
        return this.evaluationArn;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final Integer evaluationFormVersion() {
        return this.evaluationFormVersion;
    }

    public final String evaluationFormTitle() {
        return this.evaluationFormTitle;
    }

    public final EvaluationSearchMetadata metadata() {
        return this.metadata;
    }

    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSearchSummary)) {
            return false;
        }
        EvaluationSearchSummary other = (EvaluationSearchSummary)obj;
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationArn(), other.evaluationArn()) && Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.evaluationFormVersion(), other.evaluationFormVersion()) && Objects.equals(this.evaluationFormTitle(), other.evaluationFormTitle()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationSearchSummary").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationArn", (Object)this.evaluationArn()).add("EvaluationFormId", (Object)this.evaluationFormId()).add("EvaluationFormVersion", (Object)this.evaluationFormVersion()).add("EvaluationFormTitle", (Object)this.evaluationFormTitle()).add("Metadata", (Object)this.metadata()).add("Status", (Object)this.statusAsString()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationArn()));
            }
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "EvaluationFormVersion": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormVersion()));
            }
            case "EvaluationFormTitle": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormTitle()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormVersion", EVALUATION_FORM_VERSION_FIELD);
        map.put("EvaluationFormTitle", EVALUATION_FORM_TITLE_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSearchSummary, T> g) {
        return obj -> g.apply((EvaluationSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationArn;
        private String evaluationFormId;
        private Integer evaluationFormVersion;
        private String evaluationFormTitle;
        private EvaluationSearchMetadata metadata;
        private String status;
        private String evaluationType;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSearchSummary model) {
            this.evaluationId(model.evaluationId);
            this.evaluationArn(model.evaluationArn);
            this.evaluationFormId(model.evaluationFormId);
            this.evaluationFormVersion(model.evaluationFormVersion);
            this.evaluationFormTitle(model.evaluationFormTitle);
            this.metadata(model.metadata);
            this.status(model.status);
            this.evaluationType(model.evaluationType);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.tags(model.tags);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return this.evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return this.evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final String getEvaluationFormTitle() {
            return this.evaluationFormTitle;
        }

        public final void setEvaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
        }

        @Override
        public final Builder evaluationFormTitle(String evaluationFormTitle) {
            this.evaluationFormTitle = evaluationFormTitle;
            return this;
        }

        public final EvaluationSearchMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(EvaluationSearchMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EvaluationSearchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public EvaluationSearchSummary build() {
            return new EvaluationSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationSearchSummary> {
        public Builder evaluationId(String var1);

        public Builder evaluationArn(String var1);

        public Builder evaluationFormId(String var1);

        public Builder evaluationFormVersion(Integer var1);

        public Builder evaluationFormTitle(String var1);

        public Builder metadata(EvaluationSearchMetadata var1);

        default public Builder metadata(Consumer<EvaluationSearchMetadata.Builder> metadata) {
            return this.metadata((EvaluationSearchMetadata)((EvaluationSearchMetadata.Builder)EvaluationSearchMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder status(String var1);

        public Builder status(EvaluationStatus var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

