/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailureReasonCode {
    INVALID_ATTRIBUTE_KEY("INVALID_ATTRIBUTE_KEY"),
    INVALID_CUSTOMER_ENDPOINT("INVALID_CUSTOMER_ENDPOINT"),
    INVALID_SYSTEM_ENDPOINT("INVALID_SYSTEM_ENDPOINT"),
    INVALID_QUEUE("INVALID_QUEUE"),
    INVALID_OUTBOUND_STRATEGY("INVALID_OUTBOUND_STRATEGY"),
    MISSING_CAMPAIGN("MISSING_CAMPAIGN"),
    MISSING_CUSTOMER_ENDPOINT("MISSING_CUSTOMER_ENDPOINT"),
    MISSING_QUEUE_ID_AND_SYSTEM_ENDPOINT("MISSING_QUEUE_ID_AND_SYSTEM_ENDPOINT"),
    REQUEST_THROTTLED("REQUEST_THROTTLED"),
    IDEMPOTENCY_EXCEPTION("IDEMPOTENCY_EXCEPTION"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailureReasonCode> VALUE_MAP;
    private final String value;

    private FailureReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureReasonCode> knownValues() {
        EnumSet<FailureReasonCode> knownValues = EnumSet.allOf(FailureReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailureReasonCode.class, FailureReasonCode::toString);
    }
}

