/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AssociatedContactSummary;
import software.amazon.awssdk.services.connect.model.AssociatedContactSummaryListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedContactsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListAssociatedContactsResponse> {
    private static final SdkField<List<AssociatedContactSummary>> CONTACT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactSummaryList").getter(ListAssociatedContactsResponse.getter(ListAssociatedContactsResponse::contactSummaryList)).setter(ListAssociatedContactsResponse.setter(Builder::contactSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedContactSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssociatedContactsResponse.getter(ListAssociatedContactsResponse::nextToken)).setter(ListAssociatedContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssociatedContactsResponse.memberNameToFieldInitializer();
    private final List<AssociatedContactSummary> contactSummaryList;
    private final String nextToken;

    private ListAssociatedContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contactSummaryList = builder.contactSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContactSummaryList() {
        return this.contactSummaryList != null && !(this.contactSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AssociatedContactSummary> contactSummaryList() {
        return this.contactSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactSummaryList() ? this.contactSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedContactsResponse)) {
            return false;
        }
        ListAssociatedContactsResponse other = (ListAssociatedContactsResponse)((Object)obj);
        return this.hasContactSummaryList() == other.hasContactSummaryList() && Objects.equals(this.contactSummaryList(), other.contactSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedContactsResponse").add("ContactSummaryList", this.hasContactSummaryList() ? this.contactSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactSummaryList": {
                return Optional.ofNullable(clazz.cast(this.contactSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactSummaryList", CONTACT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedContactsResponse, T> g) {
        return obj -> g.apply((ListAssociatedContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<AssociatedContactSummary> contactSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedContactsResponse model) {
            super(model);
            this.contactSummaryList(model.contactSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AssociatedContactSummary.Builder> getContactSummaryList() {
            List<AssociatedContactSummary.Builder> result = AssociatedContactSummaryListCopier.copyToBuilder(this.contactSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactSummaryList(Collection<AssociatedContactSummary.BuilderImpl> contactSummaryList) {
            this.contactSummaryList = AssociatedContactSummaryListCopier.copyFromBuilder(contactSummaryList);
        }

        @Override
        public final Builder contactSummaryList(Collection<AssociatedContactSummary> contactSummaryList) {
            this.contactSummaryList = AssociatedContactSummaryListCopier.copy(contactSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactSummaryList(AssociatedContactSummary ... contactSummaryList) {
            this.contactSummaryList(Arrays.asList(contactSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactSummaryList(Consumer<AssociatedContactSummary.Builder> ... contactSummaryList) {
            this.contactSummaryList(Stream.of(contactSummaryList).map(c -> (AssociatedContactSummary)((AssociatedContactSummary.Builder)AssociatedContactSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedContactsResponse build() {
            return new ListAssociatedContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedContactsResponse> {
        public Builder contactSummaryList(Collection<AssociatedContactSummary> var1);

        public Builder contactSummaryList(AssociatedContactSummary ... var1);

        public Builder contactSummaryList(Consumer<AssociatedContactSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

