/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PrimaryValuesListCopier;
import software.amazon.awssdk.services.connect.model.RecordPrimaryValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataTablePrimaryValuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListDataTablePrimaryValuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataTablePrimaryValuesResponse.getter(ListDataTablePrimaryValuesResponse::nextToken)).setter(ListDataTablePrimaryValuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RecordPrimaryValue>> PRIMARY_VALUES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrimaryValuesList").getter(ListDataTablePrimaryValuesResponse.getter(ListDataTablePrimaryValuesResponse::primaryValuesList)).setter(ListDataTablePrimaryValuesResponse.setter(Builder::primaryValuesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValuesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordPrimaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PRIMARY_VALUES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataTablePrimaryValuesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecordPrimaryValue> primaryValuesList;

    private ListDataTablePrimaryValuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.primaryValuesList = builder.primaryValuesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPrimaryValuesList() {
        return this.primaryValuesList != null && !(this.primaryValuesList instanceof SdkAutoConstructList);
    }

    public final List<RecordPrimaryValue> primaryValuesList() {
        return this.primaryValuesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryValuesList() ? this.primaryValuesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataTablePrimaryValuesResponse)) {
            return false;
        }
        ListDataTablePrimaryValuesResponse other = (ListDataTablePrimaryValuesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPrimaryValuesList() == other.hasPrimaryValuesList() && Objects.equals(this.primaryValuesList(), other.primaryValuesList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataTablePrimaryValuesResponse").add("NextToken", (Object)this.nextToken()).add("PrimaryValuesList", this.hasPrimaryValuesList() ? this.primaryValuesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PrimaryValuesList": {
                return Optional.ofNullable(clazz.cast(this.primaryValuesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PrimaryValuesList", PRIMARY_VALUES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataTablePrimaryValuesResponse, T> g) {
        return obj -> g.apply((ListDataTablePrimaryValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecordPrimaryValue> primaryValuesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataTablePrimaryValuesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.primaryValuesList(model.primaryValuesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecordPrimaryValue.Builder> getPrimaryValuesList() {
            List<RecordPrimaryValue.Builder> result = PrimaryValuesListCopier.copyToBuilder(this.primaryValuesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValuesList(Collection<RecordPrimaryValue.BuilderImpl> primaryValuesList) {
            this.primaryValuesList = PrimaryValuesListCopier.copyFromBuilder(primaryValuesList);
        }

        @Override
        public final Builder primaryValuesList(Collection<RecordPrimaryValue> primaryValuesList) {
            this.primaryValuesList = PrimaryValuesListCopier.copy(primaryValuesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValuesList(RecordPrimaryValue ... primaryValuesList) {
            this.primaryValuesList(Arrays.asList(primaryValuesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValuesList(Consumer<RecordPrimaryValue.Builder> ... primaryValuesList) {
            this.primaryValuesList(Stream.of(primaryValuesList).map(c -> (RecordPrimaryValue)((RecordPrimaryValue.Builder)RecordPrimaryValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataTablePrimaryValuesResponse build() {
            return new ListDataTablePrimaryValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataTablePrimaryValuesResponse> {
        public Builder nextToken(String var1);

        public Builder primaryValuesList(Collection<RecordPrimaryValue> var1);

        public Builder primaryValuesList(RecordPrimaryValue ... var1);

        public Builder primaryValuesList(Consumer<RecordPrimaryValue.Builder> ... var1);
    }
}

