/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.WorkspacePage;
import software.amazon.awssdk.services.connect.model.WorkspacePageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspacePagesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListWorkspacePagesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkspacePagesResponse.getter(ListWorkspacePagesResponse::nextToken)).setter(ListWorkspacePagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WorkspacePage>> WORKSPACE_PAGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkspacePageList").getter(ListWorkspacePagesResponse.getter(ListWorkspacePagesResponse::workspacePageList)).setter(ListWorkspacePagesResponse.setter(Builder::workspacePageList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspacePageList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspacePage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKSPACE_PAGE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkspacePagesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkspacePage> workspacePageList;

    private ListWorkspacePagesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspacePageList = builder.workspacePageList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkspacePageList() {
        return this.workspacePageList != null && !(this.workspacePageList instanceof SdkAutoConstructList);
    }

    public final List<WorkspacePage> workspacePageList() {
        return this.workspacePageList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspacePageList() ? this.workspacePageList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacePagesResponse)) {
            return false;
        }
        ListWorkspacePagesResponse other = (ListWorkspacePagesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkspacePageList() == other.hasWorkspacePageList() && Objects.equals(this.workspacePageList(), other.workspacePageList());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspacePagesResponse").add("NextToken", (Object)this.nextToken()).add("WorkspacePageList", this.hasWorkspacePageList() ? this.workspacePageList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WorkspacePageList": {
                return Optional.ofNullable(clazz.cast(this.workspacePageList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WorkspacePageList", WORKSPACE_PAGE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspacePagesResponse, T> g) {
        return obj -> g.apply((ListWorkspacePagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkspacePage> workspacePageList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspacePagesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workspacePageList(model.workspacePageList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspacePage.Builder> getWorkspacePageList() {
            List<WorkspacePage.Builder> result = WorkspacePageListCopier.copyToBuilder(this.workspacePageList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspacePageList(Collection<WorkspacePage.BuilderImpl> workspacePageList) {
            this.workspacePageList = WorkspacePageListCopier.copyFromBuilder(workspacePageList);
        }

        @Override
        public final Builder workspacePageList(Collection<WorkspacePage> workspacePageList) {
            this.workspacePageList = WorkspacePageListCopier.copy(workspacePageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacePageList(WorkspacePage ... workspacePageList) {
            this.workspacePageList(Arrays.asList(workspacePageList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspacePageList(Consumer<WorkspacePage.Builder> ... workspacePageList) {
            this.workspacePageList(Stream.of(workspacePageList).map(c -> (WorkspacePage)((WorkspacePage.Builder)WorkspacePage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspacePagesResponse build() {
            return new ListWorkspacePagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspacePagesResponse> {
        public Builder nextToken(String var1);

        public Builder workspacePageList(Collection<WorkspacePage> var1);

        public Builder workspacePageList(WorkspacePage ... var1);

        public Builder workspacePageList(Consumer<WorkspacePage.Builder> ... var1);
    }
}

