/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.MediaItem;

final class MediaListCopier {
    MediaListCopier() {
    }

    static List<MediaItem> copy(Collection<? extends MediaItem> mediaListParam) {
        Object list;
        if (mediaListParam == null || mediaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(mediaListParam.size());
            mediaListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MediaItem> copyFromBuilder(Collection<? extends MediaItem.Builder> mediaListParam) {
        Object list;
        if (mediaListParam == null || mediaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(mediaListParam.size());
            mediaListParam.forEach(entry -> {
                MediaItem member = entry == null ? null : (MediaItem)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MediaItem.Builder> copyToBuilder(Collection<? extends MediaItem> mediaListParam) {
        Object list;
        if (mediaListParam == null || mediaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(mediaListParam.size());
            mediaListParam.forEach(entry -> {
                MediaItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

