/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaType {
    IMAGE_LOGO_LIGHT_FAVICON("IMAGE_LOGO_LIGHT_FAVICON"),
    IMAGE_LOGO_DARK_FAVICON("IMAGE_LOGO_DARK_FAVICON"),
    IMAGE_LOGO_LIGHT_HORIZONTAL("IMAGE_LOGO_LIGHT_HORIZONTAL"),
    IMAGE_LOGO_DARK_HORIZONTAL("IMAGE_LOGO_DARK_HORIZONTAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaType> VALUE_MAP;
    private final String value;

    private MediaType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaType> knownValues() {
        EnumSet<MediaType> knownValues = EnumSet.allOf(MediaType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaType.class, MediaType::toString);
    }
}

