/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AccessType;
import software.amazon.awssdk.services.connect.model.PrimaryValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrimaryAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrimaryAttributeValue> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(PrimaryAttributeValue.getter(PrimaryAttributeValue::accessTypeAsString)).setter(PrimaryAttributeValue.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(PrimaryAttributeValue.getter(PrimaryAttributeValue::attributeName)).setter(PrimaryAttributeValue.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(PrimaryAttributeValue.getter(PrimaryAttributeValue::values)).setter(PrimaryAttributeValue.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrimaryAttributeValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessType;
    private final String attributeName;
    private final List<String> values;

    private PrimaryAttributeValue(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.attributeName = builder.attributeName;
        this.values = builder.values;
    }

    public final AccessType accessType() {
        return AccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimaryAttributeValue)) {
            return false;
        }
        PrimaryAttributeValue other = (PrimaryAttributeValue)obj;
        return Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.attributeName(), other.attributeName()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"PrimaryAttributeValue").add("AccessType", (Object)this.accessTypeAsString()).add("AttributeName", (Object)this.attributeName()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessType", ACCESS_TYPE_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrimaryAttributeValue, T> g) {
        return obj -> g.apply((PrimaryAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessType;
        private String attributeName;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrimaryAttributeValue model) {
            this.accessType(model.accessType);
            this.attributeName(model.attributeName);
            this.values(model.values);
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = PrimaryValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PrimaryValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public PrimaryAttributeValue build() {
            return new PrimaryAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrimaryAttributeValue> {
        public Builder accessType(String var1);

        public Builder accessType(AccessType var1);

        public Builder attributeName(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

