/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.QuickConnectType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickConnectContactData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickConnectContactData> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(QuickConnectContactData.getter(QuickConnectContactData::contactId)).setter(QuickConnectContactData.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTimestamp").getter(QuickConnectContactData.getter(QuickConnectContactData::initiationTimestamp)).setter(QuickConnectContactData.setter(Builder::initiationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectId").getter(QuickConnectContactData.getter(QuickConnectContactData::quickConnectId)).setter(QuickConnectContactData.setter(Builder::quickConnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectId").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectName").getter(QuickConnectContactData.getter(QuickConnectContactData::quickConnectName)).setter(QuickConnectContactData.setter(Builder::quickConnectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectName").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectType").getter(QuickConnectContactData.getter(QuickConnectContactData::quickConnectTypeAsString)).setter(QuickConnectContactData.setter(Builder::quickConnectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, INITIATION_TIMESTAMP_FIELD, QUICK_CONNECT_ID_FIELD, QUICK_CONNECT_NAME_FIELD, QUICK_CONNECT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QuickConnectContactData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final Instant initiationTimestamp;
    private final String quickConnectId;
    private final String quickConnectName;
    private final String quickConnectType;

    private QuickConnectContactData(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.quickConnectId = builder.quickConnectId;
        this.quickConnectName = builder.quickConnectName;
        this.quickConnectType = builder.quickConnectType;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final Instant initiationTimestamp() {
        return this.initiationTimestamp;
    }

    public final String quickConnectId() {
        return this.quickConnectId;
    }

    public final String quickConnectName() {
        return this.quickConnectName;
    }

    public final QuickConnectType quickConnectType() {
        return QuickConnectType.fromValue(this.quickConnectType);
    }

    public final String quickConnectTypeAsString() {
        return this.quickConnectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickConnectContactData)) {
            return false;
        }
        QuickConnectContactData other = (QuickConnectContactData)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.initiationTimestamp(), other.initiationTimestamp()) && Objects.equals(this.quickConnectId(), other.quickConnectId()) && Objects.equals(this.quickConnectName(), other.quickConnectName()) && Objects.equals(this.quickConnectTypeAsString(), other.quickConnectTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QuickConnectContactData").add("ContactId", (Object)this.contactId()).add("InitiationTimestamp", (Object)this.initiationTimestamp()).add("QuickConnectId", (Object)this.quickConnectId()).add("QuickConnectName", (Object)this.quickConnectName()).add("QuickConnectType", (Object)this.quickConnectTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "InitiationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiationTimestamp()));
            }
            case "QuickConnectId": {
                return Optional.ofNullable(clazz.cast(this.quickConnectId()));
            }
            case "QuickConnectName": {
                return Optional.ofNullable(clazz.cast(this.quickConnectName()));
            }
            case "QuickConnectType": {
                return Optional.ofNullable(clazz.cast(this.quickConnectTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("QuickConnectId", QUICK_CONNECT_ID_FIELD);
        map.put("QuickConnectName", QUICK_CONNECT_NAME_FIELD);
        map.put("QuickConnectType", QUICK_CONNECT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickConnectContactData, T> g) {
        return obj -> g.apply((QuickConnectContactData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private Instant initiationTimestamp;
        private String quickConnectId;
        private String quickConnectName;
        private String quickConnectType;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickConnectContactData model) {
            this.contactId(model.contactId);
            this.initiationTimestamp(model.initiationTimestamp);
            this.quickConnectId(model.quickConnectId);
            this.quickConnectName(model.quickConnectName);
            this.quickConnectType(model.quickConnectType);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return this.initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final String getQuickConnectId() {
            return this.quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final String getQuickConnectName() {
            return this.quickConnectName;
        }

        public final void setQuickConnectName(String quickConnectName) {
            this.quickConnectName = quickConnectName;
        }

        @Override
        public final Builder quickConnectName(String quickConnectName) {
            this.quickConnectName = quickConnectName;
            return this;
        }

        public final String getQuickConnectType() {
            return this.quickConnectType;
        }

        public final void setQuickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
        }

        @Override
        public final Builder quickConnectType(String quickConnectType) {
            this.quickConnectType = quickConnectType;
            return this;
        }

        @Override
        public final Builder quickConnectType(QuickConnectType quickConnectType) {
            this.quickConnectType(quickConnectType == null ? null : quickConnectType.toString());
            return this;
        }

        public QuickConnectContactData build() {
            return new QuickConnectContactData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickConnectContactData> {
        public Builder contactId(String var1);

        public Builder initiationTimestamp(Instant var1);

        public Builder quickConnectId(String var1);

        public Builder quickConnectName(String var1);

        public Builder quickConnectType(String var1);

        public Builder quickConnectType(QuickConnectType var1);
    }
}

