/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.MediaStreamType;
import software.amazon.awssdk.services.connect.model.ParticipantType;
import software.amazon.awssdk.services.connect.model.RecordingStatus;
import software.amazon.awssdk.services.connect.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingInfo> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(RecordingInfo.getter(RecordingInfo::storageTypeAsString)).setter(RecordingInfo.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(RecordingInfo.getter(RecordingInfo::location)).setter(RecordingInfo.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamType").getter(RecordingInfo.getter(RecordingInfo::mediaStreamTypeAsString)).setter(RecordingInfo.setter(Builder::mediaStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamType").build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantType").getter(RecordingInfo.getter(RecordingInfo::participantTypeAsString)).setter(RecordingInfo.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()}).build();
    private static final SdkField<String> FRAGMENT_START_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FragmentStartNumber").getter(RecordingInfo.getter(RecordingInfo::fragmentStartNumber)).setter(RecordingInfo.setter(Builder::fragmentStartNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentStartNumber").build()}).build();
    private static final SdkField<String> FRAGMENT_STOP_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FragmentStopNumber").getter(RecordingInfo.getter(RecordingInfo::fragmentStopNumber)).setter(RecordingInfo.setter(Builder::fragmentStopNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentStopNumber").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(RecordingInfo.getter(RecordingInfo::startTimestamp)).setter(RecordingInfo.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> STOP_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopTimestamp").getter(RecordingInfo.getter(RecordingInfo::stopTimestamp)).setter(RecordingInfo.setter(Builder::stopTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RecordingInfo.getter(RecordingInfo::statusAsString)).setter(RecordingInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DELETION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionReason").getter(RecordingInfo.getter(RecordingInfo::deletionReason)).setter(RecordingInfo.setter(Builder::deletionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionReason").build()}).build();
    private static final SdkField<String> UNPROCESSED_TRANSCRIPT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnprocessedTranscriptLocation").getter(RecordingInfo.getter(RecordingInfo::unprocessedTranscriptLocation)).setter(RecordingInfo.setter(Builder::unprocessedTranscriptLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTranscriptLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, LOCATION_FIELD, MEDIA_STREAM_TYPE_FIELD, PARTICIPANT_TYPE_FIELD, FRAGMENT_START_NUMBER_FIELD, FRAGMENT_STOP_NUMBER_FIELD, START_TIMESTAMP_FIELD, STOP_TIMESTAMP_FIELD, STATUS_FIELD, DELETION_REASON_FIELD, UNPROCESSED_TRANSCRIPT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordingInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final String location;
    private final String mediaStreamType;
    private final String participantType;
    private final String fragmentStartNumber;
    private final String fragmentStopNumber;
    private final Instant startTimestamp;
    private final Instant stopTimestamp;
    private final String status;
    private final String deletionReason;
    private final String unprocessedTranscriptLocation;

    private RecordingInfo(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.location = builder.location;
        this.mediaStreamType = builder.mediaStreamType;
        this.participantType = builder.participantType;
        this.fragmentStartNumber = builder.fragmentStartNumber;
        this.fragmentStopNumber = builder.fragmentStopNumber;
        this.startTimestamp = builder.startTimestamp;
        this.stopTimestamp = builder.stopTimestamp;
        this.status = builder.status;
        this.deletionReason = builder.deletionReason;
        this.unprocessedTranscriptLocation = builder.unprocessedTranscriptLocation;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final String location() {
        return this.location;
    }

    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(this.mediaStreamType);
    }

    public final String mediaStreamTypeAsString() {
        return this.mediaStreamType;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final String fragmentStartNumber() {
        return this.fragmentStartNumber;
    }

    public final String fragmentStopNumber() {
        return this.fragmentStopNumber;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant stopTimestamp() {
        return this.stopTimestamp;
    }

    public final RecordingStatus status() {
        return RecordingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String deletionReason() {
        return this.deletionReason;
    }

    public final String unprocessedTranscriptLocation() {
        return this.unprocessedTranscriptLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentStartNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentStopNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedTranscriptLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingInfo)) {
            return false;
        }
        RecordingInfo other = (RecordingInfo)obj;
        return Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.mediaStreamTypeAsString(), other.mediaStreamTypeAsString()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && Objects.equals(this.fragmentStartNumber(), other.fragmentStartNumber()) && Objects.equals(this.fragmentStopNumber(), other.fragmentStopNumber()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.stopTimestamp(), other.stopTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.deletionReason(), other.deletionReason()) && Objects.equals(this.unprocessedTranscriptLocation(), other.unprocessedTranscriptLocation());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingInfo").add("StorageType", (Object)this.storageTypeAsString()).add("Location", (Object)this.location()).add("MediaStreamType", (Object)this.mediaStreamTypeAsString()).add("ParticipantType", (Object)this.participantTypeAsString()).add("FragmentStartNumber", (Object)this.fragmentStartNumber()).add("FragmentStopNumber", (Object)this.fragmentStopNumber()).add("StartTimestamp", (Object)this.startTimestamp()).add("StopTimestamp", (Object)this.stopTimestamp()).add("Status", (Object)this.statusAsString()).add("DeletionReason", (Object)this.deletionReason()).add("UnprocessedTranscriptLocation", (Object)this.unprocessedTranscriptLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "MediaStreamType": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamTypeAsString()));
            }
            case "ParticipantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "FragmentStartNumber": {
                return Optional.ofNullable(clazz.cast(this.fragmentStartNumber()));
            }
            case "FragmentStopNumber": {
                return Optional.ofNullable(clazz.cast(this.fragmentStopNumber()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "StopTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stopTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DeletionReason": {
                return Optional.ofNullable(clazz.cast(this.deletionReason()));
            }
            case "UnprocessedTranscriptLocation": {
                return Optional.ofNullable(clazz.cast(this.unprocessedTranscriptLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("MediaStreamType", MEDIA_STREAM_TYPE_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("FragmentStartNumber", FRAGMENT_START_NUMBER_FIELD);
        map.put("FragmentStopNumber", FRAGMENT_STOP_NUMBER_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("StopTimestamp", STOP_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeletionReason", DELETION_REASON_FIELD);
        map.put("UnprocessedTranscriptLocation", UNPROCESSED_TRANSCRIPT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingInfo, T> g) {
        return obj -> g.apply((RecordingInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private String location;
        private String mediaStreamType;
        private String participantType;
        private String fragmentStartNumber;
        private String fragmentStopNumber;
        private Instant startTimestamp;
        private Instant stopTimestamp;
        private String status;
        private String deletionReason;
        private String unprocessedTranscriptLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingInfo model) {
            this.storageType(model.storageType);
            this.location(model.location);
            this.mediaStreamType(model.mediaStreamType);
            this.participantType(model.participantType);
            this.fragmentStartNumber(model.fragmentStartNumber);
            this.fragmentStopNumber(model.fragmentStopNumber);
            this.startTimestamp(model.startTimestamp);
            this.stopTimestamp(model.stopTimestamp);
            this.status(model.status);
            this.deletionReason(model.deletionReason);
            this.unprocessedTranscriptLocation(model.unprocessedTranscriptLocation);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getMediaStreamType() {
            return this.mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final String getFragmentStartNumber() {
            return this.fragmentStartNumber;
        }

        public final void setFragmentStartNumber(String fragmentStartNumber) {
            this.fragmentStartNumber = fragmentStartNumber;
        }

        @Override
        public final Builder fragmentStartNumber(String fragmentStartNumber) {
            this.fragmentStartNumber = fragmentStartNumber;
            return this;
        }

        public final String getFragmentStopNumber() {
            return this.fragmentStopNumber;
        }

        public final void setFragmentStopNumber(String fragmentStopNumber) {
            this.fragmentStopNumber = fragmentStopNumber;
        }

        @Override
        public final Builder fragmentStopNumber(String fragmentStopNumber) {
            this.fragmentStopNumber = fragmentStopNumber;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getStopTimestamp() {
            return this.stopTimestamp;
        }

        public final void setStopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
        }

        @Override
        public final Builder stopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecordingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeletionReason() {
            return this.deletionReason;
        }

        public final void setDeletionReason(String deletionReason) {
            this.deletionReason = deletionReason;
        }

        @Override
        public final Builder deletionReason(String deletionReason) {
            this.deletionReason = deletionReason;
            return this;
        }

        public final String getUnprocessedTranscriptLocation() {
            return this.unprocessedTranscriptLocation;
        }

        public final void setUnprocessedTranscriptLocation(String unprocessedTranscriptLocation) {
            this.unprocessedTranscriptLocation = unprocessedTranscriptLocation;
        }

        @Override
        public final Builder unprocessedTranscriptLocation(String unprocessedTranscriptLocation) {
            this.unprocessedTranscriptLocation = unprocessedTranscriptLocation;
            return this;
        }

        public RecordingInfo build() {
            return new RecordingInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingInfo> {
        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder location(String var1);

        public Builder mediaStreamType(String var1);

        public Builder mediaStreamType(MediaStreamType var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder fragmentStartNumber(String var1);

        public Builder fragmentStopNumber(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder stopTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(RecordingStatus var1);

        public Builder deletionReason(String var1);

        public Builder unprocessedTranscriptLocation(String var1);
    }
}

