/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReferenceType {
    URL("URL"),
    ATTACHMENT("ATTACHMENT"),
    CONTACT_ANALYSIS("CONTACT_ANALYSIS"),
    NUMBER("NUMBER"),
    STRING("STRING"),
    DATE("DATE"),
    EMAIL("EMAIL"),
    EMAIL_MESSAGE("EMAIL_MESSAGE"),
    EMAIL_MESSAGE_PLAIN_TEXT("EMAIL_MESSAGE_PLAIN_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReferenceType> VALUE_MAP;
    private final String value;

    private ReferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReferenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReferenceType> knownValues() {
        EnumSet<ReferenceType> knownValues = EnumSet.allOf(ReferenceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReferenceType.class, ReferenceType::toString);
    }
}

