/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EventSourceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleTriggerEventSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleTriggerEventSource> {
    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceName").getter(RuleTriggerEventSource.getter(RuleTriggerEventSource::eventSourceNameAsString)).setter(RuleTriggerEventSource.setter(Builder::eventSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceName").build()}).build();
    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationAssociationId").getter(RuleTriggerEventSource.getter(RuleTriggerEventSource::integrationAssociationId)).setter(RuleTriggerEventSource.setter(Builder::integrationAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_NAME_FIELD, INTEGRATION_ASSOCIATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleTriggerEventSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventSourceName;
    private final String integrationAssociationId;

    private RuleTriggerEventSource(BuilderImpl builder) {
        this.eventSourceName = builder.eventSourceName;
        this.integrationAssociationId = builder.integrationAssociationId;
    }

    public final EventSourceName eventSourceName() {
        return EventSourceName.fromValue(this.eventSourceName);
    }

    public final String eventSourceNameAsString() {
        return this.eventSourceName;
    }

    public final String integrationAssociationId() {
        return this.integrationAssociationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationAssociationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTriggerEventSource)) {
            return false;
        }
        RuleTriggerEventSource other = (RuleTriggerEventSource)obj;
        return Objects.equals(this.eventSourceNameAsString(), other.eventSourceNameAsString()) && Objects.equals(this.integrationAssociationId(), other.integrationAssociationId());
    }

    public final String toString() {
        return ToString.builder((String)"RuleTriggerEventSource").add("EventSourceName", (Object)this.eventSourceNameAsString()).add("IntegrationAssociationId", (Object)this.integrationAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSourceName": {
                return Optional.ofNullable(clazz.cast(this.eventSourceNameAsString()));
            }
            case "IntegrationAssociationId": {
                return Optional.ofNullable(clazz.cast(this.integrationAssociationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EventSourceName", EVENT_SOURCE_NAME_FIELD);
        map.put("IntegrationAssociationId", INTEGRATION_ASSOCIATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleTriggerEventSource, T> g) {
        return obj -> g.apply((RuleTriggerEventSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventSourceName;
        private String integrationAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTriggerEventSource model) {
            this.eventSourceName(model.eventSourceName);
            this.integrationAssociationId(model.integrationAssociationId);
        }

        public final String getEventSourceName() {
            return this.eventSourceName;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        @Override
        public final Builder eventSourceName(EventSourceName eventSourceName) {
            this.eventSourceName(eventSourceName == null ? null : eventSourceName.toString());
            return this;
        }

        public final String getIntegrationAssociationId() {
            return this.integrationAssociationId;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public RuleTriggerEventSource build() {
            return new RuleTriggerEventSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleTriggerEventSource> {
        public Builder eventSourceName(String var1);

        public Builder eventSourceName(EventSourceName var1);

        public Builder integrationAssociationId(String var1);
    }
}

