/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.CreatedByInfo;
import software.amazon.awssdk.services.connect.model.FileUseCaseType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAttachedFileUploadRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartAttachedFileUploadRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::clientToken)).setter(StartAttachedFileUploadRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::instanceId)).setter(StartAttachedFileUploadRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::fileName)).setter(StartAttachedFileUploadRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<Long> FILE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSizeInBytes").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::fileSizeInBytes)).setter(StartAttachedFileUploadRequest.setter(Builder::fileSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeInBytes").build()}).build();
    private static final SdkField<Integer> URL_EXPIRY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UrlExpiryInSeconds").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::urlExpiryInSeconds)).setter(StartAttachedFileUploadRequest.setter(Builder::urlExpiryInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiryInSeconds").build()}).build();
    private static final SdkField<String> FILE_USE_CASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileUseCaseType").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::fileUseCaseTypeAsString)).setter(StartAttachedFileUploadRequest.setter(Builder::fileUseCaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileUseCaseType").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceArn").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::associatedResourceArn)).setter(StartAttachedFileUploadRequest.setter(Builder::associatedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build()}).build();
    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::createdBy)).setter(StartAttachedFileUploadRequest.setter(Builder::createdBy)).constructor(CreatedByInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartAttachedFileUploadRequest.getter(StartAttachedFileUploadRequest::tags)).setter(StartAttachedFileUploadRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INSTANCE_ID_FIELD, FILE_NAME_FIELD, FILE_SIZE_IN_BYTES_FIELD, URL_EXPIRY_IN_SECONDS_FIELD, FILE_USE_CASE_TYPE_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD, CREATED_BY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAttachedFileUploadRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String instanceId;
    private final String fileName;
    private final Long fileSizeInBytes;
    private final Integer urlExpiryInSeconds;
    private final String fileUseCaseType;
    private final String associatedResourceArn;
    private final CreatedByInfo createdBy;
    private final Map<String, String> tags;

    private StartAttachedFileUploadRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceId = builder.instanceId;
        this.fileName = builder.fileName;
        this.fileSizeInBytes = builder.fileSizeInBytes;
        this.urlExpiryInSeconds = builder.urlExpiryInSeconds;
        this.fileUseCaseType = builder.fileUseCaseType;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.createdBy = builder.createdBy;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final Long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public final Integer urlExpiryInSeconds() {
        return this.urlExpiryInSeconds;
    }

    public final FileUseCaseType fileUseCaseType() {
        return FileUseCaseType.fromValue(this.fileUseCaseType);
    }

    public final String fileUseCaseTypeAsString() {
        return this.fileUseCaseType;
    }

    public final String associatedResourceArn() {
        return this.associatedResourceArn;
    }

    public final CreatedByInfo createdBy() {
        return this.createdBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiryInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileUseCaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachedFileUploadRequest)) {
            return false;
        }
        StartAttachedFileUploadRequest other = (StartAttachedFileUploadRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.fileSizeInBytes(), other.fileSizeInBytes()) && Objects.equals(this.urlExpiryInSeconds(), other.urlExpiryInSeconds()) && Objects.equals(this.fileUseCaseTypeAsString(), other.fileUseCaseTypeAsString()) && Objects.equals(this.associatedResourceArn(), other.associatedResourceArn()) && Objects.equals(this.createdBy(), other.createdBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartAttachedFileUploadRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceId", (Object)this.instanceId()).add("FileName", (Object)this.fileName()).add("FileSizeInBytes", (Object)this.fileSizeInBytes()).add("UrlExpiryInSeconds", (Object)this.urlExpiryInSeconds()).add("FileUseCaseType", (Object)this.fileUseCaseTypeAsString()).add("AssociatedResourceArn", (Object)this.associatedResourceArn()).add("CreatedBy", (Object)this.createdBy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "FileSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.fileSizeInBytes()));
            }
            case "UrlExpiryInSeconds": {
                return Optional.ofNullable(clazz.cast(this.urlExpiryInSeconds()));
            }
            case "FileUseCaseType": {
                return Optional.ofNullable(clazz.cast(this.fileUseCaseTypeAsString()));
            }
            case "AssociatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("FileSizeInBytes", FILE_SIZE_IN_BYTES_FIELD);
        map.put("UrlExpiryInSeconds", URL_EXPIRY_IN_SECONDS_FIELD);
        map.put("FileUseCaseType", FILE_USE_CASE_TYPE_FIELD);
        map.put("associatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAttachedFileUploadRequest, T> g) {
        return obj -> g.apply((StartAttachedFileUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String instanceId;
        private String fileName;
        private Long fileSizeInBytes;
        private Integer urlExpiryInSeconds;
        private String fileUseCaseType;
        private String associatedResourceArn;
        private CreatedByInfo createdBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachedFileUploadRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceId(model.instanceId);
            this.fileName(model.fileName);
            this.fileSizeInBytes(model.fileSizeInBytes);
            this.urlExpiryInSeconds(model.urlExpiryInSeconds);
            this.fileUseCaseType(model.fileUseCaseType);
            this.associatedResourceArn(model.associatedResourceArn);
            this.createdBy(model.createdBy);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Long getFileSizeInBytes() {
            return this.fileSizeInBytes;
        }

        public final void setFileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
        }

        @Override
        public final Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            return this;
        }

        public final Integer getUrlExpiryInSeconds() {
            return this.urlExpiryInSeconds;
        }

        public final void setUrlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
        }

        @Override
        public final Builder urlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
            return this;
        }

        public final String getFileUseCaseType() {
            return this.fileUseCaseType;
        }

        public final void setFileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
        }

        @Override
        public final Builder fileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
            return this;
        }

        @Override
        public final Builder fileUseCaseType(FileUseCaseType fileUseCaseType) {
            this.fileUseCaseType(fileUseCaseType == null ? null : fileUseCaseType.toString());
            return this;
        }

        public final String getAssociatedResourceArn() {
            return this.associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAttachedFileUploadRequest build() {
            return new StartAttachedFileUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAttachedFileUploadRequest> {
        public Builder clientToken(String var1);

        public Builder instanceId(String var1);

        public Builder fileName(String var1);

        public Builder fileSizeInBytes(Long var1);

        public Builder urlExpiryInSeconds(Integer var1);

        public Builder fileUseCaseType(String var1);

        public Builder fileUseCaseType(FileUseCaseType var1);

        public Builder associatedResourceArn(String var1);

        public Builder createdBy(CreatedByInfo var1);

        default public Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return this.createdBy((CreatedByInfo)((CreatedByInfo.Builder)CreatedByInfo.builder().applyMutation(createdBy)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

