/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ChatMessage;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ParticipantConfiguration;
import software.amazon.awssdk.services.connect.model.ParticipantDetails;
import software.amazon.awssdk.services.connect.model.PersistentChat;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.SupportedMessagingContentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChatContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartChatContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartChatContactRequest.getter(StartChatContactRequest::instanceId)).setter(StartChatContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartChatContactRequest.getter(StartChatContactRequest::contactFlowId)).setter(StartChatContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartChatContactRequest.getter(StartChatContactRequest::attributes)).setter(StartChatContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantDetails").getter(StartChatContactRequest.getter(StartChatContactRequest::participantDetails)).setter(StartChatContactRequest.setter(Builder::participantDetails)).constructor(ParticipantDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build()}).build();
    private static final SdkField<ParticipantConfiguration> PARTICIPANT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantConfiguration").getter(StartChatContactRequest.getter(StartChatContactRequest::participantConfiguration)).setter(StartChatContactRequest.setter(Builder::participantConfiguration)).constructor(ParticipantConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantConfiguration").build()}).build();
    private static final SdkField<ChatMessage> INITIAL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialMessage").getter(StartChatContactRequest.getter(StartChatContactRequest::initialMessage)).setter(StartChatContactRequest.setter(Builder::initialMessage)).constructor(ChatMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialMessage").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartChatContactRequest.getter(StartChatContactRequest::clientToken)).setter(StartChatContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> CHAT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChatDurationInMinutes").getter(StartChatContactRequest.getter(StartChatContactRequest::chatDurationInMinutes)).setter(StartChatContactRequest.setter(Builder::chatDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatDurationInMinutes").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedMessagingContentTypes").getter(StartChatContactRequest.getter(StartChatContactRequest::supportedMessagingContentTypes)).setter(StartChatContactRequest.setter(Builder::supportedMessagingContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PersistentChat> PERSISTENT_CHAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PersistentChat").getter(StartChatContactRequest.getter(StartChatContactRequest::persistentChat)).setter(StartChatContactRequest.setter(Builder::persistentChat)).constructor(PersistentChat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentChat").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartChatContactRequest.getter(StartChatContactRequest::relatedContactId)).setter(StartChatContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(StartChatContactRequest.getter(StartChatContactRequest::segmentAttributes)).setter(StartChatContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerId").getter(StartChatContactRequest.getter(StartChatContactRequest::customerId)).setter(StartChatContactRequest.setter(Builder::customerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_FLOW_ID_FIELD, ATTRIBUTES_FIELD, PARTICIPANT_DETAILS_FIELD, PARTICIPANT_CONFIGURATION_FIELD, INITIAL_MESSAGE_FIELD, CLIENT_TOKEN_FIELD, CHAT_DURATION_IN_MINUTES_FIELD, SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, PERSISTENT_CHAT_FIELD, RELATED_CONTACT_ID_FIELD, SEGMENT_ATTRIBUTES_FIELD, CUSTOMER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartChatContactRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactFlowId;
    private final Map<String, String> attributes;
    private final ParticipantDetails participantDetails;
    private final ParticipantConfiguration participantConfiguration;
    private final ChatMessage initialMessage;
    private final String clientToken;
    private final Integer chatDurationInMinutes;
    private final List<String> supportedMessagingContentTypes;
    private final PersistentChat persistentChat;
    private final String relatedContactId;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final String customerId;

    private StartChatContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowId = builder.contactFlowId;
        this.attributes = builder.attributes;
        this.participantDetails = builder.participantDetails;
        this.participantConfiguration = builder.participantConfiguration;
        this.initialMessage = builder.initialMessage;
        this.clientToken = builder.clientToken;
        this.chatDurationInMinutes = builder.chatDurationInMinutes;
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.persistentChat = builder.persistentChat;
        this.relatedContactId = builder.relatedContactId;
        this.segmentAttributes = builder.segmentAttributes;
        this.customerId = builder.customerId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final ParticipantDetails participantDetails() {
        return this.participantDetails;
    }

    public final ParticipantConfiguration participantConfiguration() {
        return this.participantConfiguration;
    }

    public final ChatMessage initialMessage() {
        return this.initialMessage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer chatDurationInMinutes() {
        return this.chatDurationInMinutes;
    }

    public final boolean hasSupportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes != null && !(this.supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes;
    }

    public final PersistentChat persistentChat() {
        return this.persistentChat;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final String customerId() {
        return this.customerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentChat());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactRequest)) {
            return false;
        }
        StartChatContactRequest other = (StartChatContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.participantDetails(), other.participantDetails()) && Objects.equals(this.participantConfiguration(), other.participantConfiguration()) && Objects.equals(this.initialMessage(), other.initialMessage()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.chatDurationInMinutes(), other.chatDurationInMinutes()) && this.hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes() && Objects.equals(this.supportedMessagingContentTypes(), other.supportedMessagingContentTypes()) && Objects.equals(this.persistentChat(), other.persistentChat()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && Objects.equals(this.customerId(), other.customerId());
    }

    public final String toString() {
        return ToString.builder((String)"StartChatContactRequest").add("InstanceId", (Object)this.instanceId()).add("ContactFlowId", (Object)this.contactFlowId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ParticipantDetails", (Object)this.participantDetails()).add("ParticipantConfiguration", (Object)this.participantConfiguration()).add("InitialMessage", (Object)this.initialMessage()).add("ClientToken", (Object)this.clientToken()).add("ChatDurationInMinutes", (Object)this.chatDurationInMinutes()).add("SupportedMessagingContentTypes", this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null).add("PersistentChat", (Object)this.persistentChat()).add("RelatedContactId", (Object)this.relatedContactId()).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("CustomerId", (Object)(this.customerId() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ParticipantDetails": {
                return Optional.ofNullable(clazz.cast(this.participantDetails()));
            }
            case "ParticipantConfiguration": {
                return Optional.ofNullable(clazz.cast(this.participantConfiguration()));
            }
            case "InitialMessage": {
                return Optional.ofNullable(clazz.cast(this.initialMessage()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ChatDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.chatDurationInMinutes()));
            }
            case "SupportedMessagingContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedMessagingContentTypes()));
            }
            case "PersistentChat": {
                return Optional.ofNullable(clazz.cast(this.persistentChat()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "CustomerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("ParticipantConfiguration", PARTICIPANT_CONFIGURATION_FIELD);
        map.put("InitialMessage", INITIAL_MESSAGE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ChatDurationInMinutes", CHAT_DURATION_IN_MINUTES_FIELD);
        map.put("SupportedMessagingContentTypes", SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD);
        map.put("PersistentChat", PERSISTENT_CHAT_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("CustomerId", CUSTOMER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactRequest, T> g) {
        return obj -> g.apply((StartChatContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactFlowId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private ParticipantDetails participantDetails;
        private ParticipantConfiguration participantConfiguration;
        private ChatMessage initialMessage;
        private String clientToken;
        private Integer chatDurationInMinutes;
        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();
        private PersistentChat persistentChat;
        private String relatedContactId;
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String customerId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactFlowId(model.contactFlowId);
            this.attributes(model.attributes);
            this.participantDetails(model.participantDetails);
            this.participantConfiguration(model.participantConfiguration);
            this.initialMessage(model.initialMessage);
            this.clientToken(model.clientToken);
            this.chatDurationInMinutes(model.chatDurationInMinutes);
            this.supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            this.persistentChat(model.persistentChat);
            this.relatedContactId(model.relatedContactId);
            this.segmentAttributes(model.segmentAttributes);
            this.customerId(model.customerId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return this.participantDetails != null ? this.participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final ParticipantConfiguration.Builder getParticipantConfiguration() {
            return this.participantConfiguration != null ? this.participantConfiguration.toBuilder() : null;
        }

        public final void setParticipantConfiguration(ParticipantConfiguration.BuilderImpl participantConfiguration) {
            this.participantConfiguration = participantConfiguration != null ? participantConfiguration.build() : null;
        }

        @Override
        public final Builder participantConfiguration(ParticipantConfiguration participantConfiguration) {
            this.participantConfiguration = participantConfiguration;
            return this;
        }

        public final ChatMessage.Builder getInitialMessage() {
            return this.initialMessage != null ? this.initialMessage.toBuilder() : null;
        }

        public final void setInitialMessage(ChatMessage.BuilderImpl initialMessage) {
            this.initialMessage = initialMessage != null ? initialMessage.build() : null;
        }

        @Override
        public final Builder initialMessage(ChatMessage initialMessage) {
            this.initialMessage = initialMessage;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getChatDurationInMinutes() {
            return this.chatDurationInMinutes;
        }

        public final void setChatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
        }

        @Override
        public final Builder chatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
            return this;
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (this.supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String ... supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final PersistentChat.Builder getPersistentChat() {
            return this.persistentChat != null ? this.persistentChat.toBuilder() : null;
        }

        public final void setPersistentChat(PersistentChat.BuilderImpl persistentChat) {
            this.persistentChat = persistentChat != null ? persistentChat.build() : null;
        }

        @Override
        public final Builder persistentChat(PersistentChat persistentChat) {
            this.persistentChat = persistentChat;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChatContactRequest build() {
            return new StartChatContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartChatContactRequest> {
        public Builder instanceId(String var1);

        public Builder contactFlowId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder participantDetails(ParticipantDetails var1);

        default public Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return this.participantDetails((ParticipantDetails)((ParticipantDetails.Builder)ParticipantDetails.builder().applyMutation(participantDetails)).build());
        }

        public Builder participantConfiguration(ParticipantConfiguration var1);

        default public Builder participantConfiguration(Consumer<ParticipantConfiguration.Builder> participantConfiguration) {
            return this.participantConfiguration((ParticipantConfiguration)((ParticipantConfiguration.Builder)ParticipantConfiguration.builder().applyMutation(participantConfiguration)).build());
        }

        public Builder initialMessage(ChatMessage var1);

        default public Builder initialMessage(Consumer<ChatMessage.Builder> initialMessage) {
            return this.initialMessage((ChatMessage)((ChatMessage.Builder)ChatMessage.builder().applyMutation(initialMessage)).build());
        }

        public Builder clientToken(String var1);

        public Builder chatDurationInMinutes(Integer var1);

        public Builder supportedMessagingContentTypes(Collection<String> var1);

        public Builder supportedMessagingContentTypes(String ... var1);

        public Builder persistentChat(PersistentChat var1);

        default public Builder persistentChat(Consumer<PersistentChat.Builder> persistentChat) {
            return this.persistentChat((PersistentChat)((PersistentChat.Builder)PersistentChat.builder().applyMutation(persistentChat)).build());
        }

        public Builder relatedContactId(String var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder customerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

