/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactMediaProcessingFailureMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContactMediaProcessingRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartContactMediaProcessingRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartContactMediaProcessingRequest.getter(StartContactMediaProcessingRequest::instanceId)).setter(StartContactMediaProcessingRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartContactMediaProcessingRequest.getter(StartContactMediaProcessingRequest::contactId)).setter(StartContactMediaProcessingRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> PROCESSOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessorArn").getter(StartContactMediaProcessingRequest.getter(StartContactMediaProcessingRequest::processorArn)).setter(StartContactMediaProcessingRequest.setter(Builder::processorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorArn").build()}).build();
    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMode").getter(StartContactMediaProcessingRequest.getter(StartContactMediaProcessingRequest::failureModeAsString)).setter(StartContactMediaProcessingRequest.setter(Builder::failureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, PROCESSOR_ARN_FIELD, FAILURE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartContactMediaProcessingRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactId;
    private final String processorArn;
    private final String failureMode;

    private StartContactMediaProcessingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.processorArn = builder.processorArn;
        this.failureMode = builder.failureMode;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String processorArn() {
        return this.processorArn;
    }

    public final ContactMediaProcessingFailureMode failureMode() {
        return ContactMediaProcessingFailureMode.fromValue(this.failureMode);
    }

    public final String failureModeAsString() {
        return this.failureMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactMediaProcessingRequest)) {
            return false;
        }
        StartContactMediaProcessingRequest other = (StartContactMediaProcessingRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.processorArn(), other.processorArn()) && Objects.equals(this.failureModeAsString(), other.failureModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartContactMediaProcessingRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("ProcessorArn", (Object)this.processorArn()).add("FailureMode", (Object)this.failureModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ProcessorArn": {
                return Optional.ofNullable(clazz.cast(this.processorArn()));
            }
            case "FailureMode": {
                return Optional.ofNullable(clazz.cast(this.failureModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ProcessorArn", PROCESSOR_ARN_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContactMediaProcessingRequest, T> g) {
        return obj -> g.apply((StartContactMediaProcessingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private String processorArn;
        private String failureMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactMediaProcessingRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.processorArn(model.processorArn);
            this.failureMode(model.failureMode);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getProcessorArn() {
            return this.processorArn;
        }

        public final void setProcessorArn(String processorArn) {
            this.processorArn = processorArn;
        }

        @Override
        public final Builder processorArn(String processorArn) {
            this.processorArn = processorArn;
            return this;
        }

        public final String getFailureMode() {
            return this.failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(ContactMediaProcessingFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartContactMediaProcessingRequest build() {
            return new StartContactMediaProcessingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContactMediaProcessingRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder processorArn(String var1);

        public Builder failureMode(String var1);

        public Builder failureMode(ContactMediaProcessingFailureMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

