/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AgentStatusState;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentStatusRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateAgentStatusRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::instanceId)).setter(UpdateAgentStatusRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> AGENT_STATUS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentStatusId").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::agentStatusId)).setter(UpdateAgentStatusRequest.setter(Builder::agentStatusId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AgentStatusId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::name)).setter(UpdateAgentStatusRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::description)).setter(UpdateAgentStatusRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::stateAsString)).setter(UpdateAgentStatusRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DisplayOrder").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::displayOrder)).setter(UpdateAgentStatusRequest.setter(Builder::displayOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOrder").build()}).build();
    private static final SdkField<Boolean> RESET_ORDER_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResetOrderNumber").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::resetOrderNumber)).setter(UpdateAgentStatusRequest.setter(Builder::resetOrderNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetOrderNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, AGENT_STATUS_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, DISPLAY_ORDER_FIELD, RESET_ORDER_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgentStatusRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String agentStatusId;
    private final String name;
    private final String description;
    private final String state;
    private final Integer displayOrder;
    private final Boolean resetOrderNumber;

    private UpdateAgentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.agentStatusId = builder.agentStatusId;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
        this.displayOrder = builder.displayOrder;
        this.resetOrderNumber = builder.resetOrderNumber;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String agentStatusId() {
        return this.agentStatusId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AgentStatusState state() {
        return AgentStatusState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer displayOrder() {
        return this.displayOrder;
    }

    public final Boolean resetOrderNumber() {
        return this.resetOrderNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetOrderNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentStatusRequest)) {
            return false;
        }
        UpdateAgentStatusRequest other = (UpdateAgentStatusRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.agentStatusId(), other.agentStatusId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.displayOrder(), other.displayOrder()) && Objects.equals(this.resetOrderNumber(), other.resetOrderNumber());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentStatusRequest").add("InstanceId", (Object)this.instanceId()).add("AgentStatusId", (Object)this.agentStatusId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("DisplayOrder", (Object)this.displayOrder()).add("ResetOrderNumber", (Object)this.resetOrderNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AgentStatusId": {
                return Optional.ofNullable(clazz.cast(this.agentStatusId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "DisplayOrder": {
                return Optional.ofNullable(clazz.cast(this.displayOrder()));
            }
            case "ResetOrderNumber": {
                return Optional.ofNullable(clazz.cast(this.resetOrderNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AgentStatusId", AGENT_STATUS_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("DisplayOrder", DISPLAY_ORDER_FIELD);
        map.put("ResetOrderNumber", RESET_ORDER_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentStatusRequest, T> g) {
        return obj -> g.apply((UpdateAgentStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String agentStatusId;
        private String name;
        private String description;
        private String state;
        private Integer displayOrder;
        private Boolean resetOrderNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentStatusRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.agentStatusId(model.agentStatusId);
            this.name(model.name);
            this.description(model.description);
            this.state(model.state);
            this.displayOrder(model.displayOrder);
            this.resetOrderNumber(model.resetOrderNumber);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAgentStatusId() {
            return this.agentStatusId;
        }

        public final void setAgentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
        }

        @Override
        public final Builder agentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AgentStatusState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final Boolean getResetOrderNumber() {
            return this.resetOrderNumber;
        }

        public final void setResetOrderNumber(Boolean resetOrderNumber) {
            this.resetOrderNumber = resetOrderNumber;
        }

        @Override
        public final Builder resetOrderNumber(Boolean resetOrderNumber) {
            this.resetOrderNumber = resetOrderNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentStatusRequest build() {
            return new UpdateAgentStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentStatusRequest> {
        public Builder instanceId(String var1);

        public Builder agentStatusId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(AgentStatusState var1);

        public Builder displayOrder(Integer var1);

        public Builder resetOrderNumber(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

