/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AiAgentInfo;
import software.amazon.awssdk.services.connect.model.AiAgentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WisdomInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WisdomInfo> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionArn").getter(WisdomInfo.getter(WisdomInfo::sessionArn)).setter(WisdomInfo.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()}).build();
    private static final SdkField<List<AiAgentInfo>> AI_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AiAgents").getter(WisdomInfo.getter(WisdomInfo::aiAgents)).setter(WisdomInfo.setter(Builder::aiAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AiAgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, AI_AGENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WisdomInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionArn;
    private final List<AiAgentInfo> aiAgents;

    private WisdomInfo(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.aiAgents = builder.aiAgents;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final boolean hasAiAgents() {
        return this.aiAgents != null && !(this.aiAgents instanceof SdkAutoConstructList);
    }

    public final List<AiAgentInfo> aiAgents() {
        return this.aiAgents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAiAgents() ? this.aiAgents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WisdomInfo)) {
            return false;
        }
        WisdomInfo other = (WisdomInfo)obj;
        return Objects.equals(this.sessionArn(), other.sessionArn()) && this.hasAiAgents() == other.hasAiAgents() && Objects.equals(this.aiAgents(), other.aiAgents());
    }

    public final String toString() {
        return ToString.builder((String)"WisdomInfo").add("SessionArn", (Object)this.sessionArn()).add("AiAgents", this.hasAiAgents() ? this.aiAgents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "AiAgents": {
                return Optional.ofNullable(clazz.cast(this.aiAgents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("AiAgents", AI_AGENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WisdomInfo, T> g) {
        return obj -> g.apply((WisdomInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionArn;
        private List<AiAgentInfo> aiAgents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WisdomInfo model) {
            this.sessionArn(model.sessionArn);
            this.aiAgents(model.aiAgents);
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final List<AiAgentInfo.Builder> getAiAgents() {
            List<AiAgentInfo.Builder> result = AiAgentsCopier.copyToBuilder(this.aiAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiAgents(Collection<AiAgentInfo.BuilderImpl> aiAgents) {
            this.aiAgents = AiAgentsCopier.copyFromBuilder(aiAgents);
        }

        @Override
        public final Builder aiAgents(Collection<AiAgentInfo> aiAgents) {
            this.aiAgents = AiAgentsCopier.copy(aiAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgents(AiAgentInfo ... aiAgents) {
            this.aiAgents(Arrays.asList(aiAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgents(Consumer<AiAgentInfo.Builder> ... aiAgents) {
            this.aiAgents(Stream.of(aiAgents).map(c -> (AiAgentInfo)((AiAgentInfo.Builder)AiAgentInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WisdomInfo build() {
            return new WisdomInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WisdomInfo> {
        public Builder sessionArn(String var1);

        public Builder aiAgents(Collection<AiAgentInfo> var1);

        public Builder aiAgents(AiAgentInfo ... var1);

        public Builder aiAgents(Consumer<AiAgentInfo.Builder> ... var1);
    }
}

