/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.LexBotConfig;
import software.amazon.awssdk.services.connect.model.ListBotsRequest;
import software.amazon.awssdk.services.connect.model.ListBotsResponse;

public class ListBotsIterable
implements SdkIterable<ListBotsResponse> {
    private final ConnectClient client;
    private final ListBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotsIterable(ConnectClient client, ListBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBotsResponseFetcher();
    }

    public Iterator<ListBotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LexBotConfig> lexBots() {
        Function<ListBotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lexBots() != null) {
                return response.lexBots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBotsResponseFetcher
    implements SyncPageFetcher<ListBotsResponse> {
        private ListBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotsResponse nextPage(ListBotsResponse previousPage) {
            if (previousPage == null) {
                return ListBotsIterable.this.client.listBots(ListBotsIterable.this.firstRequest);
            }
            return ListBotsIterable.this.client.listBots((ListBotsRequest)((Object)ListBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

