/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleVersionSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsResponse;

public class ListContactFlowModuleVersionsPublisher
implements SdkPublisher<ListContactFlowModuleVersionsResponse> {
    private final ConnectAsyncClient client;
    private final ListContactFlowModuleVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactFlowModuleVersionsPublisher(ConnectAsyncClient client, ListContactFlowModuleVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactFlowModuleVersionsPublisher(ConnectAsyncClient client, ListContactFlowModuleVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactFlowModuleVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactFlowModuleVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowModuleVersionSummary> contactFlowModuleVersionSummaryList() {
        Function<ListContactFlowModuleVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModuleVersionSummaryList() != null) {
                return response.contactFlowModuleVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactFlowModuleVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactFlowModuleVersionsResponseFetcher
    implements AsyncPageFetcher<ListContactFlowModuleVersionsResponse> {
        private ListContactFlowModuleVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowModuleVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactFlowModuleVersionsResponse> nextPage(ListContactFlowModuleVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowModuleVersionsPublisher.this.client.listContactFlowModuleVersions(ListContactFlowModuleVersionsPublisher.this.firstRequest);
            }
            return ListContactFlowModuleVersionsPublisher.this.client.listContactFlowModuleVersions((ListContactFlowModuleVersionsRequest)((Object)ListContactFlowModuleVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

