/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileSummary;

public class ListRoutingProfilesPublisher
implements SdkPublisher<ListRoutingProfilesResponse> {
    private final ConnectAsyncClient client;
    private final ListRoutingProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoutingProfilesPublisher(ConnectAsyncClient client, ListRoutingProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoutingProfilesPublisher(ConnectAsyncClient client, ListRoutingProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoutingProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoutingProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoutingProfileSummary> routingProfileSummaryList() {
        Function<ListRoutingProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfileSummaryList() != null) {
                return response.routingProfileSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoutingProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoutingProfilesResponseFetcher
    implements AsyncPageFetcher<ListRoutingProfilesResponse> {
        private ListRoutingProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoutingProfilesResponse> nextPage(ListRoutingProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingProfilesPublisher.this.client.listRoutingProfiles(ListRoutingProfilesPublisher.this.firstRequest);
            }
            return ListRoutingProfilesPublisher.this.client.listRoutingProfiles((ListRoutingProfilesRequest)((Object)ListRoutingProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

