/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HierarchyGroup;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsResponse;

public class SearchUserHierarchyGroupsPublisher
implements SdkPublisher<SearchUserHierarchyGroupsResponse> {
    private final ConnectAsyncClient client;
    private final SearchUserHierarchyGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchUserHierarchyGroupsPublisher(ConnectAsyncClient client, SearchUserHierarchyGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchUserHierarchyGroupsPublisher(ConnectAsyncClient client, SearchUserHierarchyGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchUserHierarchyGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchUserHierarchyGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HierarchyGroup> userHierarchyGroups() {
        Function<SearchUserHierarchyGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userHierarchyGroups() != null) {
                return response.userHierarchyGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchUserHierarchyGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchUserHierarchyGroupsResponseFetcher
    implements AsyncPageFetcher<SearchUserHierarchyGroupsResponse> {
        private SearchUserHierarchyGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchUserHierarchyGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchUserHierarchyGroupsResponse> nextPage(SearchUserHierarchyGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchUserHierarchyGroupsPublisher.this.client.searchUserHierarchyGroups(SearchUserHierarchyGroupsPublisher.this.firstRequest);
            }
            return SearchUserHierarchyGroupsPublisher.this.client.searchUserHierarchyGroups((SearchUserHierarchyGroupsRequest)((Object)SearchUserHierarchyGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

