/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.WorkspaceSearchSummary;

public class SearchWorkspacesPublisher
implements SdkPublisher<SearchWorkspacesResponse> {
    private final ConnectAsyncClient client;
    private final SearchWorkspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchWorkspacesPublisher(ConnectAsyncClient client, SearchWorkspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchWorkspacesPublisher(ConnectAsyncClient client, SearchWorkspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchWorkspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchWorkspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkspaceSearchSummary> workspaces() {
        Function<SearchWorkspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workspaces() != null) {
                return response.workspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchWorkspacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchWorkspacesResponseFetcher
    implements AsyncPageFetcher<SearchWorkspacesResponse> {
        private SearchWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(SearchWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchWorkspacesResponse> nextPage(SearchWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return SearchWorkspacesPublisher.this.client.searchWorkspaces(SearchWorkspacesPublisher.this.firstRequest);
            }
            return SearchWorkspacesPublisher.this.client.searchWorkspaces((SearchWorkspacesRequest)((Object)SearchWorkspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

