/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyServerlessCacheSnapshotRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CopyServerlessCacheSnapshotRequest> {
    private static final SdkField<String> SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceServerlessCacheSnapshotName").getter(CopyServerlessCacheSnapshotRequest.getter(CopyServerlessCacheSnapshotRequest::sourceServerlessCacheSnapshotName)).setter(CopyServerlessCacheSnapshotRequest.setter(Builder::sourceServerlessCacheSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceServerlessCacheSnapshotName").build()}).build();
    private static final SdkField<String> TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetServerlessCacheSnapshotName").getter(CopyServerlessCacheSnapshotRequest.getter(CopyServerlessCacheSnapshotRequest::targetServerlessCacheSnapshotName)).setter(CopyServerlessCacheSnapshotRequest.setter(Builder::targetServerlessCacheSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetServerlessCacheSnapshotName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CopyServerlessCacheSnapshotRequest.getter(CopyServerlessCacheSnapshotRequest::kmsKeyId)).setter(CopyServerlessCacheSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopyServerlessCacheSnapshotRequest.getter(CopyServerlessCacheSnapshotRequest::tags)).setter(CopyServerlessCacheSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CopyServerlessCacheSnapshotRequest.memberNameToFieldInitializer();
    private final String sourceServerlessCacheSnapshotName;
    private final String targetServerlessCacheSnapshotName;
    private final String kmsKeyId;
    private final List<Tag> tags;

    private CopyServerlessCacheSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceServerlessCacheSnapshotName = builder.sourceServerlessCacheSnapshotName;
        this.targetServerlessCacheSnapshotName = builder.targetServerlessCacheSnapshotName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
    }

    public final String sourceServerlessCacheSnapshotName() {
        return this.sourceServerlessCacheSnapshotName;
    }

    public final String targetServerlessCacheSnapshotName() {
        return this.targetServerlessCacheSnapshotName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetServerlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyServerlessCacheSnapshotRequest)) {
            return false;
        }
        CopyServerlessCacheSnapshotRequest other = (CopyServerlessCacheSnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceServerlessCacheSnapshotName(), other.sourceServerlessCacheSnapshotName()) && Objects.equals(this.targetServerlessCacheSnapshotName(), other.targetServerlessCacheSnapshotName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CopyServerlessCacheSnapshotRequest").add("SourceServerlessCacheSnapshotName", (Object)this.sourceServerlessCacheSnapshotName()).add("TargetServerlessCacheSnapshotName", (Object)this.targetServerlessCacheSnapshotName()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceServerlessCacheSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceServerlessCacheSnapshotName()));
            }
            case "TargetServerlessCacheSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetServerlessCacheSnapshotName()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceServerlessCacheSnapshotName", SOURCE_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("TargetServerlessCacheSnapshotName", TARGET_SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyServerlessCacheSnapshotRequest, T> g) {
        return obj -> g.apply((CopyServerlessCacheSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String sourceServerlessCacheSnapshotName;
        private String targetServerlessCacheSnapshotName;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyServerlessCacheSnapshotRequest model) {
            super(model);
            this.sourceServerlessCacheSnapshotName(model.sourceServerlessCacheSnapshotName);
            this.targetServerlessCacheSnapshotName(model.targetServerlessCacheSnapshotName);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
        }

        public final String getSourceServerlessCacheSnapshotName() {
            return this.sourceServerlessCacheSnapshotName;
        }

        public final void setSourceServerlessCacheSnapshotName(String sourceServerlessCacheSnapshotName) {
            this.sourceServerlessCacheSnapshotName = sourceServerlessCacheSnapshotName;
        }

        @Override
        public final Builder sourceServerlessCacheSnapshotName(String sourceServerlessCacheSnapshotName) {
            this.sourceServerlessCacheSnapshotName = sourceServerlessCacheSnapshotName;
            return this;
        }

        public final String getTargetServerlessCacheSnapshotName() {
            return this.targetServerlessCacheSnapshotName;
        }

        public final void setTargetServerlessCacheSnapshotName(String targetServerlessCacheSnapshotName) {
            this.targetServerlessCacheSnapshotName = targetServerlessCacheSnapshotName;
        }

        @Override
        public final Builder targetServerlessCacheSnapshotName(String targetServerlessCacheSnapshotName) {
            this.targetServerlessCacheSnapshotName = targetServerlessCacheSnapshotName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyServerlessCacheSnapshotRequest build() {
            return new CopyServerlessCacheSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyServerlessCacheSnapshotRequest> {
        public Builder sourceServerlessCacheSnapshotName(String var1);

        public Builder targetServerlessCacheSnapshotName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

