/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroup;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheParameterGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheParameterGroupsResponse.getter(DescribeCacheParameterGroupsResponse::marker)).setter(DescribeCacheParameterGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<CacheParameterGroup>> CACHE_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheParameterGroups").getter(DescribeCacheParameterGroupsResponse.getter(DescribeCacheParameterGroupsResponse::cacheParameterGroups)).setter(DescribeCacheParameterGroupsResponse.setter(Builder::cacheParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroups").build(), ListTrait.builder().memberLocationName("CacheParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheParameterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CACHE_PARAMETER_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCacheParameterGroupsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<CacheParameterGroup> cacheParameterGroups;

    private DescribeCacheParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheParameterGroups = builder.cacheParameterGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasCacheParameterGroups() {
        return this.cacheParameterGroups != null && !(this.cacheParameterGroups instanceof SdkAutoConstructList);
    }

    public final List<CacheParameterGroup> cacheParameterGroups() {
        return this.cacheParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheParameterGroups() ? this.cacheParameterGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParameterGroupsResponse)) {
            return false;
        }
        DescribeCacheParameterGroupsResponse other = (DescribeCacheParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasCacheParameterGroups() == other.hasCacheParameterGroups() && Objects.equals(this.cacheParameterGroups(), other.cacheParameterGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCacheParameterGroupsResponse").add("Marker", (Object)this.marker()).add("CacheParameterGroups", this.hasCacheParameterGroups() ? this.cacheParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CacheParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("CacheParameterGroups", CACHE_PARAMETER_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeCacheParameterGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheParameterGroup> cacheParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.cacheParameterGroups(model.cacheParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<CacheParameterGroup.Builder> getCacheParameterGroups() {
            List<CacheParameterGroup.Builder> result = CacheParameterGroupListCopier.copyToBuilder(this.cacheParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheParameterGroups(Collection<CacheParameterGroup.BuilderImpl> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copyFromBuilder(cacheParameterGroups);
        }

        @Override
        public final Builder cacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copy(cacheParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(CacheParameterGroup ... cacheParameterGroups) {
            this.cacheParameterGroups(Arrays.asList(cacheParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(Consumer<CacheParameterGroup.Builder> ... cacheParameterGroups) {
            this.cacheParameterGroups(Stream.of(cacheParameterGroups).map(c -> (CacheParameterGroup)((CacheParameterGroup.Builder)CacheParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCacheParameterGroupsResponse build() {
            return new DescribeCacheParameterGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheParameterGroups(Collection<CacheParameterGroup> var1);

        public Builder cacheParameterGroups(CacheParameterGroup ... var1);

        public Builder cacheParameterGroups(Consumer<CacheParameterGroup.Builder> ... var1);
    }
}

