/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TileAdditionalFeature {
    CONTOUR_LINES("ContourLines"),
    HILLSHADE("Hillshade"),
    LOGISTICS("Logistics"),
    TRANSIT("Transit"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TileAdditionalFeature> VALUE_MAP;
    private final String value;

    private TileAdditionalFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TileAdditionalFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TileAdditionalFeature> knownValues() {
        EnumSet<TileAdditionalFeature> knownValues = EnumSet.allOf(TileAdditionalFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TileAdditionalFeature.class, TileAdditionalFeature::toString);
    }
}

