/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ComponentConfigurationListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ContainerType;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerRecipeRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateContainerRecipeRequest> {
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerType").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::containerTypeAsString)).setter(CreateContainerRecipeRequest.setter(Builder::containerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::name)).setter(CreateContainerRecipeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::description)).setter(CreateContainerRecipeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("semanticVersion").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::semanticVersion)).setter(CreateContainerRecipeRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<List<ComponentConfiguration>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("components").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::components)).setter(CreateContainerRecipeRequest.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceConfiguration").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::instanceConfiguration)).setter(CreateContainerRecipeRequest.setter(Builder::instanceConfiguration)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfiguration").build()}).build();
    private static final SdkField<String> DOCKERFILE_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dockerfileTemplateData").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::dockerfileTemplateData)).setter(CreateContainerRecipeRequest.setter(Builder::dockerfileTemplateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateData").build()}).build();
    private static final SdkField<String> DOCKERFILE_TEMPLATE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dockerfileTemplateUri").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::dockerfileTemplateUri)).setter(CreateContainerRecipeRequest.setter(Builder::dockerfileTemplateUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerfileTemplateUri").build()}).build();
    private static final SdkField<String> PLATFORM_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformOverride").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::platformOverrideAsString)).setter(CreateContainerRecipeRequest.setter(Builder::platformOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformOverride").build()}).build();
    private static final SdkField<String> IMAGE_OS_VERSION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageOsVersionOverride").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::imageOsVersionOverride)).setter(CreateContainerRecipeRequest.setter(Builder::imageOsVersionOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageOsVersionOverride").build()}).build();
    private static final SdkField<String> PARENT_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentImage").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::parentImage)).setter(CreateContainerRecipeRequest.setter(Builder::parentImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentImage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::tags)).setter(CreateContainerRecipeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workingDirectory").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::workingDirectory)).setter(CreateContainerRecipeRequest.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()}).build();
    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetRepository").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::targetRepository)).setter(CreateContainerRecipeRequest.setter(Builder::targetRepository)).constructor(TargetContainerRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::kmsKeyId)).setter(CreateContainerRecipeRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateContainerRecipeRequest.getter(CreateContainerRecipeRequest::clientToken)).setter(CreateContainerRecipeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SEMANTIC_VERSION_FIELD, COMPONENTS_FIELD, INSTANCE_CONFIGURATION_FIELD, DOCKERFILE_TEMPLATE_DATA_FIELD, DOCKERFILE_TEMPLATE_URI_FIELD, PLATFORM_OVERRIDE_FIELD, IMAGE_OS_VERSION_OVERRIDE_FIELD, PARENT_IMAGE_FIELD, TAGS_FIELD, WORKING_DIRECTORY_FIELD, TARGET_REPOSITORY_FIELD, KMS_KEY_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContainerRecipeRequest.memberNameToFieldInitializer();
    private final String containerType;
    private final String name;
    private final String description;
    private final String semanticVersion;
    private final List<ComponentConfiguration> components;
    private final InstanceConfiguration instanceConfiguration;
    private final String dockerfileTemplateData;
    private final String dockerfileTemplateUri;
    private final String platformOverride;
    private final String imageOsVersionOverride;
    private final String parentImage;
    private final Map<String, String> tags;
    private final String workingDirectory;
    private final TargetContainerRepository targetRepository;
    private final String kmsKeyId;
    private final String clientToken;

    private CreateContainerRecipeRequest(BuilderImpl builder) {
        super(builder);
        this.containerType = builder.containerType;
        this.name = builder.name;
        this.description = builder.description;
        this.semanticVersion = builder.semanticVersion;
        this.components = builder.components;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.dockerfileTemplateData = builder.dockerfileTemplateData;
        this.dockerfileTemplateUri = builder.dockerfileTemplateUri;
        this.platformOverride = builder.platformOverride;
        this.imageOsVersionOverride = builder.imageOsVersionOverride;
        this.parentImage = builder.parentImage;
        this.tags = builder.tags;
        this.workingDirectory = builder.workingDirectory;
        this.targetRepository = builder.targetRepository;
        this.kmsKeyId = builder.kmsKeyId;
        this.clientToken = builder.clientToken;
    }

    public final ContainerType containerType() {
        return ContainerType.fromValue(this.containerType);
    }

    public final String containerTypeAsString() {
        return this.containerType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<ComponentConfiguration> components() {
        return this.components;
    }

    public final InstanceConfiguration instanceConfiguration() {
        return this.instanceConfiguration;
    }

    public final String dockerfileTemplateData() {
        return this.dockerfileTemplateData;
    }

    public final String dockerfileTemplateUri() {
        return this.dockerfileTemplateUri;
    }

    public final Platform platformOverride() {
        return Platform.fromValue(this.platformOverride);
    }

    public final String platformOverrideAsString() {
        return this.platformOverride;
    }

    public final String imageOsVersionOverride() {
        return this.imageOsVersionOverride;
    }

    public final String parentImage() {
        return this.parentImage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final TargetContainerRepository targetRepository() {
        return this.targetRepository;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerfileTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerfileTemplateUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOsVersionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerRecipeRequest)) {
            return false;
        }
        CreateContainerRecipeRequest other = (CreateContainerRecipeRequest)((Object)obj);
        return Objects.equals(this.containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.instanceConfiguration(), other.instanceConfiguration()) && Objects.equals(this.dockerfileTemplateData(), other.dockerfileTemplateData()) && Objects.equals(this.dockerfileTemplateUri(), other.dockerfileTemplateUri()) && Objects.equals(this.platformOverrideAsString(), other.platformOverrideAsString()) && Objects.equals(this.imageOsVersionOverride(), other.imageOsVersionOverride()) && Objects.equals(this.parentImage(), other.parentImage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.targetRepository(), other.targetRepository()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerRecipeRequest").add("ContainerType", (Object)this.containerTypeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SemanticVersion", (Object)this.semanticVersion()).add("Components", this.hasComponents() ? this.components() : null).add("InstanceConfiguration", (Object)this.instanceConfiguration()).add("DockerfileTemplateData", (Object)this.dockerfileTemplateData()).add("DockerfileTemplateUri", (Object)this.dockerfileTemplateUri()).add("PlatformOverride", (Object)this.platformOverrideAsString()).add("ImageOsVersionOverride", (Object)this.imageOsVersionOverride()).add("ParentImage", (Object)this.parentImage()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkingDirectory", (Object)this.workingDirectory()).add("TargetRepository", (Object)this.targetRepository()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerType": {
                return Optional.ofNullable(clazz.cast(this.containerTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "semanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "instanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceConfiguration()));
            }
            case "dockerfileTemplateData": {
                return Optional.ofNullable(clazz.cast(this.dockerfileTemplateData()));
            }
            case "dockerfileTemplateUri": {
                return Optional.ofNullable(clazz.cast(this.dockerfileTemplateUri()));
            }
            case "platformOverride": {
                return Optional.ofNullable(clazz.cast(this.platformOverrideAsString()));
            }
            case "imageOsVersionOverride": {
                return Optional.ofNullable(clazz.cast(this.imageOsVersionOverride()));
            }
            case "parentImage": {
                return Optional.ofNullable(clazz.cast(this.parentImage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "targetRepository": {
                return Optional.ofNullable(clazz.cast(this.targetRepository()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerType", CONTAINER_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("semanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("components", COMPONENTS_FIELD);
        map.put("instanceConfiguration", INSTANCE_CONFIGURATION_FIELD);
        map.put("dockerfileTemplateData", DOCKERFILE_TEMPLATE_DATA_FIELD);
        map.put("dockerfileTemplateUri", DOCKERFILE_TEMPLATE_URI_FIELD);
        map.put("platformOverride", PLATFORM_OVERRIDE_FIELD);
        map.put("imageOsVersionOverride", IMAGE_OS_VERSION_OVERRIDE_FIELD);
        map.put("parentImage", PARENT_IMAGE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workingDirectory", WORKING_DIRECTORY_FIELD);
        map.put("targetRepository", TARGET_REPOSITORY_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerRecipeRequest, T> g) {
        return obj -> g.apply((CreateContainerRecipeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String containerType;
        private String name;
        private String description;
        private String semanticVersion;
        private List<ComponentConfiguration> components = DefaultSdkAutoConstructList.getInstance();
        private InstanceConfiguration instanceConfiguration;
        private String dockerfileTemplateData;
        private String dockerfileTemplateUri;
        private String platformOverride;
        private String imageOsVersionOverride;
        private String parentImage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workingDirectory;
        private TargetContainerRepository targetRepository;
        private String kmsKeyId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerRecipeRequest model) {
            super(model);
            this.containerType(model.containerType);
            this.name(model.name);
            this.description(model.description);
            this.semanticVersion(model.semanticVersion);
            this.components(model.components);
            this.instanceConfiguration(model.instanceConfiguration);
            this.dockerfileTemplateData(model.dockerfileTemplateData);
            this.dockerfileTemplateUri(model.dockerfileTemplateUri);
            this.platformOverride(model.platformOverride);
            this.imageOsVersionOverride(model.imageOsVersionOverride);
            this.parentImage(model.parentImage);
            this.tags(model.tags);
            this.workingDirectory(model.workingDirectory);
            this.targetRepository(model.targetRepository);
            this.kmsKeyId(model.kmsKeyId);
            this.clientToken(model.clientToken);
        }

        public final String getContainerType() {
            return this.containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final List<ComponentConfiguration.Builder> getComponents() {
            List<ComponentConfiguration.Builder> result = ComponentConfigurationListCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponents(Collection<ComponentConfiguration.BuilderImpl> components) {
            this.components = ComponentConfigurationListCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Collection<ComponentConfiguration> components) {
            this.components = ComponentConfigurationListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(ComponentConfiguration ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(Consumer<ComponentConfiguration.Builder> ... components) {
            this.components(Stream.of(components).map(c -> (ComponentConfiguration)((ComponentConfiguration.Builder)ComponentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return this.instanceConfiguration != null ? this.instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getDockerfileTemplateData() {
            return this.dockerfileTemplateData;
        }

        public final void setDockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
        }

        @Override
        public final Builder dockerfileTemplateData(String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        public final String getDockerfileTemplateUri() {
            return this.dockerfileTemplateUri;
        }

        public final void setDockerfileTemplateUri(String dockerfileTemplateUri) {
            this.dockerfileTemplateUri = dockerfileTemplateUri;
        }

        @Override
        public final Builder dockerfileTemplateUri(String dockerfileTemplateUri) {
            this.dockerfileTemplateUri = dockerfileTemplateUri;
            return this;
        }

        public final String getPlatformOverride() {
            return this.platformOverride;
        }

        public final void setPlatformOverride(String platformOverride) {
            this.platformOverride = platformOverride;
        }

        @Override
        public final Builder platformOverride(String platformOverride) {
            this.platformOverride = platformOverride;
            return this;
        }

        @Override
        public final Builder platformOverride(Platform platformOverride) {
            this.platformOverride(platformOverride == null ? null : platformOverride.toString());
            return this;
        }

        public final String getImageOsVersionOverride() {
            return this.imageOsVersionOverride;
        }

        public final void setImageOsVersionOverride(String imageOsVersionOverride) {
            this.imageOsVersionOverride = imageOsVersionOverride;
        }

        @Override
        public final Builder imageOsVersionOverride(String imageOsVersionOverride) {
            this.imageOsVersionOverride = imageOsVersionOverride;
            return this;
        }

        public final String getParentImage() {
            return this.parentImage;
        }

        public final void setParentImage(String parentImage) {
            this.parentImage = parentImage;
        }

        @Override
        public final Builder parentImage(String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return this.targetRepository != null ? this.targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerRecipeRequest build() {
            return new CreateContainerRecipeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerRecipeRequest> {
        public Builder containerType(String var1);

        public Builder containerType(ContainerType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder semanticVersion(String var1);

        public Builder components(Collection<ComponentConfiguration> var1);

        public Builder components(ComponentConfiguration ... var1);

        public Builder components(Consumer<ComponentConfiguration.Builder> ... var1);

        public Builder instanceConfiguration(InstanceConfiguration var1);

        default public Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return this.instanceConfiguration((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instanceConfiguration)).build());
        }

        public Builder dockerfileTemplateData(String var1);

        public Builder dockerfileTemplateUri(String var1);

        public Builder platformOverride(String var1);

        public Builder platformOverride(Platform var1);

        public Builder imageOsVersionOverride(String var1);

        public Builder parentImage(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder workingDirectory(String var1);

        public Builder targetRepository(TargetContainerRepository var1);

        default public Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return this.targetRepository((TargetContainerRepository)((TargetContainerRepository.Builder)TargetContainerRepository.builder().applyMutation(targetRepository)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

