/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions;
import software.amazon.awssdk.services.imagebuilder.model.InstanceTypeListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Logging;
import software.amazon.awssdk.services.imagebuilder.model.Placement;
import software.amazon.awssdk.services.imagebuilder.model.ResourceTagMapCopier;
import software.amazon.awssdk.services.imagebuilder.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInfrastructureConfigurationRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateInfrastructureConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::name)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::description)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::instanceTypes)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceProfileName").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::instanceProfileName)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileName").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::securityGroupIds)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subnetId").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::subnetId)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::logging)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPair").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::keyPair)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCE_ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("terminateInstanceOnFailure").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::terminateInstanceOnFailure)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::terminateInstanceOnFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateInstanceOnFailure").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopicArn").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::snsTopicArn)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceTags").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::resourceTags)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<InstanceMetadataOptions> INSTANCE_METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceMetadataOptions").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::instanceMetadataOptions)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::instanceMetadataOptions)).constructor(InstanceMetadataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMetadataOptions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::tags)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("placement").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::placement)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placement").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::clientToken)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INSTANCE_TYPES_FIELD, INSTANCE_PROFILE_NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, LOGGING_FIELD, KEY_PAIR_FIELD, TERMINATE_INSTANCE_ON_FAILURE_FIELD, SNS_TOPIC_ARN_FIELD, RESOURCE_TAGS_FIELD, INSTANCE_METADATA_OPTIONS_FIELD, TAGS_FIELD, PLACEMENT_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInfrastructureConfigurationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<String> instanceTypes;
    private final String instanceProfileName;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final Logging logging;
    private final String keyPair;
    private final Boolean terminateInstanceOnFailure;
    private final String snsTopicArn;
    private final Map<String, String> resourceTags;
    private final InstanceMetadataOptions instanceMetadataOptions;
    private final Map<String, String> tags;
    private final Placement placement;
    private final String clientToken;

    private CreateInfrastructureConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.instanceTypes = builder.instanceTypes;
        this.instanceProfileName = builder.instanceProfileName;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.logging = builder.logging;
        this.keyPair = builder.keyPair;
        this.terminateInstanceOnFailure = builder.terminateInstanceOnFailure;
        this.snsTopicArn = builder.snsTopicArn;
        this.resourceTags = builder.resourceTags;
        this.instanceMetadataOptions = builder.instanceMetadataOptions;
        this.tags = builder.tags;
        this.placement = builder.placement;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final String keyPair() {
        return this.keyPair;
    }

    public final Boolean terminateInstanceOnFailure() {
        return this.terminateInstanceOnFailure;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public final InstanceMetadataOptions instanceMetadataOptions() {
        return this.instanceMetadataOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstanceOnFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInfrastructureConfigurationRequest)) {
            return false;
        }
        CreateInfrastructureConfigurationRequest other = (CreateInfrastructureConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.terminateInstanceOnFailure(), other.terminateInstanceOnFailure()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.instanceMetadataOptions(), other.instanceMetadataOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInfrastructureConfigurationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("InstanceProfileName", (Object)this.instanceProfileName()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetId", (Object)this.subnetId()).add("Logging", (Object)this.logging()).add("KeyPair", (Object)this.keyPair()).add("TerminateInstanceOnFailure", (Object)this.terminateInstanceOnFailure()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("InstanceMetadataOptions", (Object)this.instanceMetadataOptions()).add("Tags", this.hasTags() ? this.tags() : null).add("Placement", (Object)this.placement()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "instanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "keyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "terminateInstanceOnFailure": {
                return Optional.ofNullable(clazz.cast(this.terminateInstanceOnFailure()));
            }
            case "snsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "instanceMetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataOptions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("instanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetId", SUBNET_ID_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("keyPair", KEY_PAIR_FIELD);
        map.put("terminateInstanceOnFailure", TERMINATE_INSTANCE_ON_FAILURE_FIELD);
        map.put("snsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        map.put("instanceMetadataOptions", INSTANCE_METADATA_OPTIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("placement", PLACEMENT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInfrastructureConfigurationRequest, T> g) {
        return obj -> g.apply((CreateInfrastructureConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String instanceProfileName;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private Logging logging;
        private String keyPair;
        private Boolean terminateInstanceOnFailure;
        private String snsTopicArn;
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();
        private InstanceMetadataOptions instanceMetadataOptions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Placement placement;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInfrastructureConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.instanceTypes(model.instanceTypes);
            this.instanceProfileName(model.instanceProfileName);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.logging(model.logging);
            this.keyPair(model.keyPair);
            this.terminateInstanceOnFailure(model.terminateInstanceOnFailure);
            this.snsTopicArn(model.snsTopicArn);
            this.resourceTags(model.resourceTags);
            this.instanceMetadataOptions(model.instanceMetadataOptions);
            this.tags(model.tags);
            this.placement(model.placement);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final Boolean getTerminateInstanceOnFailure() {
            return this.terminateInstanceOnFailure;
        }

        public final void setTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
        }

        @Override
        public final Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = ResourceTagMapCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = ResourceTagMapCopier.copy(resourceTags);
            return this;
        }

        public final InstanceMetadataOptions.Builder getInstanceMetadataOptions() {
            return this.instanceMetadataOptions != null ? this.instanceMetadataOptions.toBuilder() : null;
        }

        public final void setInstanceMetadataOptions(InstanceMetadataOptions.BuilderImpl instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions != null ? instanceMetadataOptions.build() : null;
        }

        @Override
        public final Builder instanceMetadataOptions(InstanceMetadataOptions instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInfrastructureConfigurationRequest build() {
            return new CreateInfrastructureConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInfrastructureConfigurationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder instanceProfileName(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder keyPair(String var1);

        public Builder terminateInstanceOnFailure(Boolean var1);

        public Builder snsTopicArn(String var1);

        public Builder resourceTags(Map<String, String> var1);

        public Builder instanceMetadataOptions(InstanceMetadataOptions var1);

        default public Builder instanceMetadataOptions(Consumer<InstanceMetadataOptions.Builder> instanceMetadataOptions) {
            return this.instanceMetadataOptions((InstanceMetadataOptions)((InstanceMetadataOptions.Builder)InstanceMetadataOptions.builder().applyMutation(instanceMetadataOptions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

