/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CisReportStatus {
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    IN_PROGRESS("IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CisReportStatus> VALUE_MAP;
    private final String value;

    private CisReportStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CisReportStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CisReportStatus> knownValues() {
        EnumSet<CisReportStatus> knownValues = EnumSet.allOf(CisReportStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CisReportStatus.class, CisReportStatus::toString);
    }
}

