/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    ALREADY_ENABLED("ALREADY_ENABLED"),
    ENABLE_IN_PROGRESS("ENABLE_IN_PROGRESS"),
    DISABLE_IN_PROGRESS("DISABLE_IN_PROGRESS"),
    SUSPEND_IN_PROGRESS("SUSPEND_IN_PROGRESS"),
    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),
    ACCESS_DENIED("ACCESS_DENIED"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    SSM_UNAVAILABLE("SSM_UNAVAILABLE"),
    SSM_THROTTLED("SSM_THROTTLED"),
    EVENTBRIDGE_UNAVAILABLE("EVENTBRIDGE_UNAVAILABLE"),
    EVENTBRIDGE_THROTTLED("EVENTBRIDGE_THROTTLED"),
    RESOURCE_SCAN_NOT_DISABLED("RESOURCE_SCAN_NOT_DISABLED"),
    DISASSOCIATE_ALL_MEMBERS("DISASSOCIATE_ALL_MEMBERS"),
    ACCOUNT_IS_ISOLATED("ACCOUNT_IS_ISOLATED"),
    EC2_SSM_RESOURCE_DATA_SYNC_LIMIT_EXCEEDED("EC2_SSM_RESOURCE_DATA_SYNC_LIMIT_EXCEEDED"),
    EC2_SSM_ASSOCIATION_VERSION_LIMIT_EXCEEDED("EC2_SSM_ASSOCIATION_VERSION_LIMIT_EXCEEDED"),
    BLOCKED_BY_ORGANIZATION_POLICY("BLOCKED_BY_ORGANIZATION_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

