/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.Permission;

public class ListAccountPermissionsIterable
implements SdkIterable<ListAccountPermissionsResponse> {
    private final Inspector2Client client;
    private final ListAccountPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountPermissionsIterable(Inspector2Client client, ListAccountPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountPermissionsResponseFetcher();
    }

    public Iterator<ListAccountPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Permission> permissions() {
        Function<ListAccountPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountPermissionsResponseFetcher
    implements SyncPageFetcher<ListAccountPermissionsResponse> {
        private ListAccountPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountPermissionsResponse nextPage(ListAccountPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountPermissionsIterable.this.client.listAccountPermissions(ListAccountPermissionsIterable.this.firstRequest);
            }
            return ListAccountPermissionsIterable.this.client.listAccountPermissions((ListAccountPermissionsRequest)((Object)ListAccountPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

