/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VersioningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VersioningConfiguration> {
    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("unlimited").getter(VersioningConfiguration.getter(VersioningConfiguration::unlimited)).setter(VersioningConfiguration.setter(Builder::unlimited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlimited").build()}).build();
    private static final SdkField<Integer> MAX_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxVersions").getter(VersioningConfiguration.getter(VersioningConfiguration::maxVersions)).setter(VersioningConfiguration.setter(Builder::maxVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxVersions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLIMITED_FIELD, MAX_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VersioningConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean unlimited;
    private final Integer maxVersions;

    private VersioningConfiguration(BuilderImpl builder) {
        this.unlimited = builder.unlimited;
        this.maxVersions = builder.maxVersions;
    }

    public final Boolean unlimited() {
        return this.unlimited;
    }

    public final Integer maxVersions() {
        return this.maxVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unlimited());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVersions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersioningConfiguration)) {
            return false;
        }
        VersioningConfiguration other = (VersioningConfiguration)obj;
        return Objects.equals(this.unlimited(), other.unlimited()) && Objects.equals(this.maxVersions(), other.maxVersions());
    }

    public final String toString() {
        return ToString.builder((String)"VersioningConfiguration").add("Unlimited", (Object)this.unlimited()).add("MaxVersions", (Object)this.maxVersions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "unlimited": {
                return Optional.ofNullable(clazz.cast(this.unlimited()));
            }
            case "maxVersions": {
                return Optional.ofNullable(clazz.cast(this.maxVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unlimited", UNLIMITED_FIELD);
        map.put("maxVersions", MAX_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersioningConfiguration, T> g) {
        return obj -> g.apply((VersioningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean unlimited;
        private Integer maxVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(VersioningConfiguration model) {
            this.unlimited(model.unlimited);
            this.maxVersions(model.maxVersions);
        }

        public final Boolean getUnlimited() {
            return this.unlimited;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        @Override
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        public final Integer getMaxVersions() {
            return this.maxVersions;
        }

        public final void setMaxVersions(Integer maxVersions) {
            this.maxVersions = maxVersions;
        }

        @Override
        public final Builder maxVersions(Integer maxVersions) {
            this.maxVersions = maxVersions;
            return this;
        }

        public VersioningConfiguration build() {
            return new VersioningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VersioningConfiguration> {
        public Builder unlimited(Boolean var1);

        public Builder maxVersions(Integer var1);
    }
}

