/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RetryCriteriaFailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryConfigCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetryConfigCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureType").getter(RetryConfigCriteria.getter(RetryConfigCriteria::failureTypeAsString)).setter(RetryConfigCriteria.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()}).build();
    private static final SdkField<Integer> MIN_NUMBER_OF_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinNumberOfRetries").getter(RetryConfigCriteria.getter(RetryConfigCriteria::minNumberOfRetries)).setter(RetryConfigCriteria.setter(Builder::minNumberOfRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinNumberOfRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD, MIN_NUMBER_OF_RETRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetryConfigCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String failureType;
    private final Integer minNumberOfRetries;

    private RetryConfigCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.minNumberOfRetries = builder.minNumberOfRetries;
    }

    public final RetryCriteriaFailureType failureType() {
        return RetryCriteriaFailureType.fromValue(this.failureType);
    }

    public final String failureTypeAsString() {
        return this.failureType;
    }

    public final Integer minNumberOfRetries() {
        return this.minNumberOfRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minNumberOfRetries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryConfigCriteria)) {
            return false;
        }
        RetryConfigCriteria other = (RetryConfigCriteria)obj;
        return Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.minNumberOfRetries(), other.minNumberOfRetries());
    }

    public final String toString() {
        return ToString.builder((String)"RetryConfigCriteria").add("FailureType", (Object)this.failureTypeAsString()).add("MinNumberOfRetries", (Object)this.minNumberOfRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "MinNumberOfRetries": {
                return Optional.ofNullable(clazz.cast(this.minNumberOfRetries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailureType", FAILURE_TYPE_FIELD);
        map.put("MinNumberOfRetries", MIN_NUMBER_OF_RETRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryConfigCriteria, T> g) {
        return obj -> g.apply((RetryConfigCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureType;
        private Integer minNumberOfRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryConfigCriteria model) {
            this.failureType(model.failureType);
            this.minNumberOfRetries(model.minNumberOfRetries);
        }

        public final String getFailureType() {
            return this.failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(RetryCriteriaFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getMinNumberOfRetries() {
            return this.minNumberOfRetries;
        }

        public final void setMinNumberOfRetries(Integer minNumberOfRetries) {
            this.minNumberOfRetries = minNumberOfRetries;
        }

        @Override
        public final Builder minNumberOfRetries(Integer minNumberOfRetries) {
            this.minNumberOfRetries = minNumberOfRetries;
            return this;
        }

        public RetryConfigCriteria build() {
            return new RetryConfigCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetryConfigCriteria> {
        public Builder failureType(String var1);

        public Builder failureType(RetryCriteriaFailureType var1);

        public Builder minNumberOfRetries(Integer var1);
    }
}

