/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorItem;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse;

public class ListCloudConnectorsIterable
implements SdkIterable<ListCloudConnectorsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListCloudConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudConnectorsIterable(IotManagedIntegrationsClient client, ListCloudConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudConnectorsResponseFetcher();
    }

    public Iterator<ListCloudConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectorItem> items() {
        Function<ListCloudConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudConnectorsResponseFetcher
    implements SyncPageFetcher<ListCloudConnectorsResponse> {
        private ListCloudConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudConnectorsResponse nextPage(ListCloudConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListCloudConnectorsIterable.this.client.listCloudConnectors(ListCloudConnectorsIterable.this.firstRequest);
            }
            return ListCloudConnectorsIterable.this.client.listCloudConnectors((ListCloudConnectorsRequest)((Object)ListCloudConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

