/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorItem;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse;

public class ListCloudConnectorsPublisher
implements SdkPublisher<ListCloudConnectorsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListCloudConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudConnectorsPublisher(IotManagedIntegrationsAsyncClient client, ListCloudConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudConnectorsPublisher(IotManagedIntegrationsAsyncClient client, ListCloudConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectorItem> items() {
        Function<ListCloudConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudConnectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudConnectorsResponseFetcher
    implements AsyncPageFetcher<ListCloudConnectorsResponse> {
        private ListCloudConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCloudConnectorsResponse> nextPage(ListCloudConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListCloudConnectorsPublisher.this.client.listCloudConnectors(ListCloudConnectorsPublisher.this.firstRequest);
            }
            return ListCloudConnectorsPublisher.this.client.listCloudConnectors((ListCloudConnectorsRequest)((Object)ListCloudConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

